(*---------------------------------------------------------------------------
   Copyright (c) 2025 The cmarkit programmers. All rights reserved.
   SPDX-License-Identifier: ISC
  ---------------------------------------------------------------------------*)

(* Do not edit. Data generated by support/unicode_data.ml *)

let unicode_version = "17.0.0"

let whitespace =
  [|0x0009; 0x000A; 0x000C; 0x000D; 0x0020; 0x00A0; 0x1680; 0x2000; 0x2001;
    0x2002; 0x2003; 0x2004; 0x2005; 0x2006; 0x2007; 0x2008; 0x2009; 0x200A;
    0x202F; 0x205F; 0x3000|]

let punctuation =
  [|0x0021; 0x0022; 0x0023; 0x0024; 0x0025; 0x0026; 0x0027; 0x0028; 0x0029;
    0x002A; 0x002B; 0x002C; 0x002D; 0x002E; 0x002F; 0x003A; 0x003B; 0x003C;
    0x003D; 0x003E; 0x003F; 0x0040; 0x005B; 0x005C; 0x005D; 0x005E; 0x005F;
    0x0060; 0x007B; 0x007C; 0x007D; 0x007E; 0x00A1; 0x00A2; 0x00A3; 0x00A4;
    0x00A5; 0x00A6; 0x00A7; 0x00A8; 0x00A9; 0x00AB; 0x00AC; 0x00AE; 0x00AF;
    0x00B0; 0x00B1; 0x00B4; 0x00B6; 0x00B7; 0x00B8; 0x00BB; 0x00BF; 0x00D7;
    0x00F7; 0x02C2; 0x02C3; 0x02C4; 0x02C5; 0x02D2; 0x02D3; 0x02D4; 0x02D5;
    0x02D6; 0x02D7; 0x02D8; 0x02D9; 0x02DA; 0x02DB; 0x02DC; 0x02DD; 0x02DE;
    0x02DF; 0x02E5; 0x02E6; 0x02E7; 0x02E8; 0x02E9; 0x02EA; 0x02EB; 0x02ED;
    0x02EF; 0x02F0; 0x02F1; 0x02F2; 0x02F3; 0x02F4; 0x02F5; 0x02F6; 0x02F7;
    0x02F8; 0x02F9; 0x02FA; 0x02FB; 0x02FC; 0x02FD; 0x02FE; 0x02FF; 0x0375;
    0x037E; 0x0384; 0x0385; 0x0387; 0x03F6; 0x0482; 0x055A; 0x055B; 0x055C;
    0x055D; 0x055E; 0x055F; 0x0589; 0x058A; 0x058D; 0x058E; 0x058F; 0x05BE;
    0x05C0; 0x05C3; 0x05C6; 0x05F3; 0x05F4; 0x0606; 0x0607; 0x0608; 0x0609;
    0x060A; 0x060B; 0x060C; 0x060D; 0x060E; 0x060F; 0x061B; 0x061D; 0x061E;
    0x061F; 0x066A; 0x066B; 0x066C; 0x066D; 0x06D4; 0x06DE; 0x06E9; 0x06FD;
    0x06FE; 0x0700; 0x0701; 0x0702; 0x0703; 0x0704; 0x0705; 0x0706; 0x0707;
    0x0708; 0x0709; 0x070A; 0x070B; 0x070C; 0x070D; 0x07F6; 0x07F7; 0x07F8;
    0x07F9; 0x07FE; 0x07FF; 0x0830; 0x0831; 0x0832; 0x0833; 0x0834; 0x0835;
    0x0836; 0x0837; 0x0838; 0x0839; 0x083A; 0x083B; 0x083C; 0x083D; 0x083E;
    0x085E; 0x0888; 0x0964; 0x0965; 0x0970; 0x09F2; 0x09F3; 0x09FA; 0x09FB;
    0x09FD; 0x0A76; 0x0AF0; 0x0AF1; 0x0B70; 0x0BF3; 0x0BF4; 0x0BF5; 0x0BF6;
    0x0BF7; 0x0BF8; 0x0BF9; 0x0BFA; 0x0C77; 0x0C7F; 0x0C84; 0x0D4F; 0x0D79;
    0x0DF4; 0x0E3F; 0x0E4F; 0x0E5A; 0x0E5B; 0x0F01; 0x0F02; 0x0F03; 0x0F04;
    0x0F05; 0x0F06; 0x0F07; 0x0F08; 0x0F09; 0x0F0A; 0x0F0B; 0x0F0C; 0x0F0D;
    0x0F0E; 0x0F0F; 0x0F10; 0x0F11; 0x0F12; 0x0F13; 0x0F14; 0x0F15; 0x0F16;
    0x0F17; 0x0F1A; 0x0F1B; 0x0F1C; 0x0F1D; 0x0F1E; 0x0F1F; 0x0F34; 0x0F36;
    0x0F38; 0x0F3A; 0x0F3B; 0x0F3C; 0x0F3D; 0x0F85; 0x0FBE; 0x0FBF; 0x0FC0;
    0x0FC1; 0x0FC2; 0x0FC3; 0x0FC4; 0x0FC5; 0x0FC7; 0x0FC8; 0x0FC9; 0x0FCA;
    0x0FCB; 0x0FCC; 0x0FCE; 0x0FCF; 0x0FD0; 0x0FD1; 0x0FD2; 0x0FD3; 0x0FD4;
    0x0FD5; 0x0FD6; 0x0FD7; 0x0FD8; 0x0FD9; 0x0FDA; 0x104A; 0x104B; 0x104C;
    0x104D; 0x104E; 0x104F; 0x109E; 0x109F; 0x10FB; 0x1360; 0x1361; 0x1362;
    0x1363; 0x1364; 0x1365; 0x1366; 0x1367; 0x1368; 0x1390; 0x1391; 0x1392;
    0x1393; 0x1394; 0x1395; 0x1396; 0x1397; 0x1398; 0x1399; 0x1400; 0x166D;
    0x166E; 0x169B; 0x169C; 0x16EB; 0x16EC; 0x16ED; 0x1735; 0x1736; 0x17D4;
    0x17D5; 0x17D6; 0x17D8; 0x17D9; 0x17DA; 0x17DB; 0x1800; 0x1801; 0x1802;
    0x1803; 0x1804; 0x1805; 0x1806; 0x1807; 0x1808; 0x1809; 0x180A; 0x1940;
    0x1944; 0x1945; 0x19DE; 0x19DF; 0x19E0; 0x19E1; 0x19E2; 0x19E3; 0x19E4;
    0x19E5; 0x19E6; 0x19E7; 0x19E8; 0x19E9; 0x19EA; 0x19EB; 0x19EC; 0x19ED;
    0x19EE; 0x19EF; 0x19F0; 0x19F1; 0x19F2; 0x19F3; 0x19F4; 0x19F5; 0x19F6;
    0x19F7; 0x19F8; 0x19F9; 0x19FA; 0x19FB; 0x19FC; 0x19FD; 0x19FE; 0x19FF;
    0x1A1E; 0x1A1F; 0x1AA0; 0x1AA1; 0x1AA2; 0x1AA3; 0x1AA4; 0x1AA5; 0x1AA6;
    0x1AA8; 0x1AA9; 0x1AAA; 0x1AAB; 0x1AAC; 0x1AAD; 0x1B4E; 0x1B4F; 0x1B5A;
    0x1B5B; 0x1B5C; 0x1B5D; 0x1B5E; 0x1B5F; 0x1B60; 0x1B61; 0x1B62; 0x1B63;
    0x1B64; 0x1B65; 0x1B66; 0x1B67; 0x1B68; 0x1B69; 0x1B6A; 0x1B74; 0x1B75;
    0x1B76; 0x1B77; 0x1B78; 0x1B79; 0x1B7A; 0x1B7B; 0x1B7C; 0x1B7D; 0x1B7E;
    0x1B7F; 0x1BFC; 0x1BFD; 0x1BFE; 0x1BFF; 0x1C3B; 0x1C3C; 0x1C3D; 0x1C3E;
    0x1C3F; 0x1C7E; 0x1C7F; 0x1CC0; 0x1CC1; 0x1CC2; 0x1CC3; 0x1CC4; 0x1CC5;
    0x1CC6; 0x1CC7; 0x1CD3; 0x1FBD; 0x1FBF; 0x1FC0; 0x1FC1; 0x1FCD; 0x1FCE;
    0x1FCF; 0x1FDD; 0x1FDE; 0x1FDF; 0x1FED; 0x1FEE; 0x1FEF; 0x1FFD; 0x1FFE;
    0x2010; 0x2011; 0x2012; 0x2013; 0x2014; 0x2015; 0x2016; 0x2017; 0x2018;
    0x2019; 0x201A; 0x201B; 0x201C; 0x201D; 0x201E; 0x201F; 0x2020; 0x2021;
    0x2022; 0x2023; 0x2024; 0x2025; 0x2026; 0x2027; 0x2030; 0x2031; 0x2032;
    0x2033; 0x2034; 0x2035; 0x2036; 0x2037; 0x2038; 0x2039; 0x203A; 0x203B;
    0x203C; 0x203D; 0x203E; 0x203F; 0x2040; 0x2041; 0x2042; 0x2043; 0x2044;
    0x2045; 0x2046; 0x2047; 0x2048; 0x2049; 0x204A; 0x204B; 0x204C; 0x204D;
    0x204E; 0x204F; 0x2050; 0x2051; 0x2052; 0x2053; 0x2054; 0x2055; 0x2056;
    0x2057; 0x2058; 0x2059; 0x205A; 0x205B; 0x205C; 0x205D; 0x205E; 0x207A;
    0x207B; 0x207C; 0x207D; 0x207E; 0x208A; 0x208B; 0x208C; 0x208D; 0x208E;
    0x20A0; 0x20A1; 0x20A2; 0x20A3; 0x20A4; 0x20A5; 0x20A6; 0x20A7; 0x20A8;
    0x20A9; 0x20AA; 0x20AB; 0x20AC; 0x20AD; 0x20AE; 0x20AF; 0x20B0; 0x20B1;
    0x20B2; 0x20B3; 0x20B4; 0x20B5; 0x20B6; 0x20B7; 0x20B8; 0x20B9; 0x20BA;
    0x20BB; 0x20BC; 0x20BD; 0x20BE; 0x20BF; 0x20C0; 0x20C1; 0x2100; 0x2101;
    0x2103; 0x2104; 0x2105; 0x2106; 0x2108; 0x2109; 0x2114; 0x2116; 0x2117;
    0x2118; 0x211E; 0x211F; 0x2120; 0x2121; 0x2122; 0x2123; 0x2125; 0x2127;
    0x2129; 0x212E; 0x213A; 0x213B; 0x2140; 0x2141; 0x2142; 0x2143; 0x2144;
    0x214A; 0x214B; 0x214C; 0x214D; 0x214F; 0x218A; 0x218B; 0x2190; 0x2191;
    0x2192; 0x2193; 0x2194; 0x2195; 0x2196; 0x2197; 0x2198; 0x2199; 0x219A;
    0x219B; 0x219C; 0x219D; 0x219E; 0x219F; 0x21A0; 0x21A1; 0x21A2; 0x21A3;
    0x21A4; 0x21A5; 0x21A6; 0x21A7; 0x21A8; 0x21A9; 0x21AA; 0x21AB; 0x21AC;
    0x21AD; 0x21AE; 0x21AF; 0x21B0; 0x21B1; 0x21B2; 0x21B3; 0x21B4; 0x21B5;
    0x21B6; 0x21B7; 0x21B8; 0x21B9; 0x21BA; 0x21BB; 0x21BC; 0x21BD; 0x21BE;
    0x21BF; 0x21C0; 0x21C1; 0x21C2; 0x21C3; 0x21C4; 0x21C5; 0x21C6; 0x21C7;
    0x21C8; 0x21C9; 0x21CA; 0x21CB; 0x21CC; 0x21CD; 0x21CE; 0x21CF; 0x21D0;
    0x21D1; 0x21D2; 0x21D3; 0x21D4; 0x21D5; 0x21D6; 0x21D7; 0x21D8; 0x21D9;
    0x21DA; 0x21DB; 0x21DC; 0x21DD; 0x21DE; 0x21DF; 0x21E0; 0x21E1; 0x21E2;
    0x21E3; 0x21E4; 0x21E5; 0x21E6; 0x21E7; 0x21E8; 0x21E9; 0x21EA; 0x21EB;
    0x21EC; 0x21ED; 0x21EE; 0x21EF; 0x21F0; 0x21F1; 0x21F2; 0x21F3; 0x21F4;
    0x21F5; 0x21F6; 0x21F7; 0x21F8; 0x21F9; 0x21FA; 0x21FB; 0x21FC; 0x21FD;
    0x21FE; 0x21FF; 0x2200; 0x2201; 0x2202; 0x2203; 0x2204; 0x2205; 0x2206;
    0x2207; 0x2208; 0x2209; 0x220A; 0x220B; 0x220C; 0x220D; 0x220E; 0x220F;
    0x2210; 0x2211; 0x2212; 0x2213; 0x2214; 0x2215; 0x2216; 0x2217; 0x2218;
    0x2219; 0x221A; 0x221B; 0x221C; 0x221D; 0x221E; 0x221F; 0x2220; 0x2221;
    0x2222; 0x2223; 0x2224; 0x2225; 0x2226; 0x2227; 0x2228; 0x2229; 0x222A;
    0x222B; 0x222C; 0x222D; 0x222E; 0x222F; 0x2230; 0x2231; 0x2232; 0x2233;
    0x2234; 0x2235; 0x2236; 0x2237; 0x2238; 0x2239; 0x223A; 0x223B; 0x223C;
    0x223D; 0x223E; 0x223F; 0x2240; 0x2241; 0x2242; 0x2243; 0x2244; 0x2245;
    0x2246; 0x2247; 0x2248; 0x2249; 0x224A; 0x224B; 0x224C; 0x224D; 0x224E;
    0x224F; 0x2250; 0x2251; 0x2252; 0x2253; 0x2254; 0x2255; 0x2256; 0x2257;
    0x2258; 0x2259; 0x225A; 0x225B; 0x225C; 0x225D; 0x225E; 0x225F; 0x2260;
    0x2261; 0x2262; 0x2263; 0x2264; 0x2265; 0x2266; 0x2267; 0x2268; 0x2269;
    0x226A; 0x226B; 0x226C; 0x226D; 0x226E; 0x226F; 0x2270; 0x2271; 0x2272;
    0x2273; 0x2274; 0x2275; 0x2276; 0x2277; 0x2278; 0x2279; 0x227A; 0x227B;
    0x227C; 0x227D; 0x227E; 0x227F; 0x2280; 0x2281; 0x2282; 0x2283; 0x2284;
    0x2285; 0x2286; 0x2287; 0x2288; 0x2289; 0x228A; 0x228B; 0x228C; 0x228D;
    0x228E; 0x228F; 0x2290; 0x2291; 0x2292; 0x2293; 0x2294; 0x2295; 0x2296;
    0x2297; 0x2298; 0x2299; 0x229A; 0x229B; 0x229C; 0x229D; 0x229E; 0x229F;
    0x22A0; 0x22A1; 0x22A2; 0x22A3; 0x22A4; 0x22A5; 0x22A6; 0x22A7; 0x22A8;
    0x22A9; 0x22AA; 0x22AB; 0x22AC; 0x22AD; 0x22AE; 0x22AF; 0x22B0; 0x22B1;
    0x22B2; 0x22B3; 0x22B4; 0x22B5; 0x22B6; 0x22B7; 0x22B8; 0x22B9; 0x22BA;
    0x22BB; 0x22BC; 0x22BD; 0x22BE; 0x22BF; 0x22C0; 0x22C1; 0x22C2; 0x22C3;
    0x22C4; 0x22C5; 0x22C6; 0x22C7; 0x22C8; 0x22C9; 0x22CA; 0x22CB; 0x22CC;
    0x22CD; 0x22CE; 0x22CF; 0x22D0; 0x22D1; 0x22D2; 0x22D3; 0x22D4; 0x22D5;
    0x22D6; 0x22D7; 0x22D8; 0x22D9; 0x22DA; 0x22DB; 0x22DC; 0x22DD; 0x22DE;
    0x22DF; 0x22E0; 0x22E1; 0x22E2; 0x22E3; 0x22E4; 0x22E5; 0x22E6; 0x22E7;
    0x22E8; 0x22E9; 0x22EA; 0x22EB; 0x22EC; 0x22ED; 0x22EE; 0x22EF; 0x22F0;
    0x22F1; 0x22F2; 0x22F3; 0x22F4; 0x22F5; 0x22F6; 0x22F7; 0x22F8; 0x22F9;
    0x22FA; 0x22FB; 0x22FC; 0x22FD; 0x22FE; 0x22FF; 0x2300; 0x2301; 0x2302;
    0x2303; 0x2304; 0x2305; 0x2306; 0x2307; 0x2308; 0x2309; 0x230A; 0x230B;
    0x230C; 0x230D; 0x230E; 0x230F; 0x2310; 0x2311; 0x2312; 0x2313; 0x2314;
    0x2315; 0x2316; 0x2317; 0x2318; 0x2319; 0x231A; 0x231B; 0x231C; 0x231D;
    0x231E; 0x231F; 0x2320; 0x2321; 0x2322; 0x2323; 0x2324; 0x2325; 0x2326;
    0x2327; 0x2328; 0x2329; 0x232A; 0x232B; 0x232C; 0x232D; 0x232E; 0x232F;
    0x2330; 0x2331; 0x2332; 0x2333; 0x2334; 0x2335; 0x2336; 0x2337; 0x2338;
    0x2339; 0x233A; 0x233B; 0x233C; 0x233D; 0x233E; 0x233F; 0x2340; 0x2341;
    0x2342; 0x2343; 0x2344; 0x2345; 0x2346; 0x2347; 0x2348; 0x2349; 0x234A;
    0x234B; 0x234C; 0x234D; 0x234E; 0x234F; 0x2350; 0x2351; 0x2352; 0x2353;
    0x2354; 0x2355; 0x2356; 0x2357; 0x2358; 0x2359; 0x235A; 0x235B; 0x235C;
    0x235D; 0x235E; 0x235F; 0x2360; 0x2361; 0x2362; 0x2363; 0x2364; 0x2365;
    0x2366; 0x2367; 0x2368; 0x2369; 0x236A; 0x236B; 0x236C; 0x236D; 0x236E;
    0x236F; 0x2370; 0x2371; 0x2372; 0x2373; 0x2374; 0x2375; 0x2376; 0x2377;
    0x2378; 0x2379; 0x237A; 0x237B; 0x237C; 0x237D; 0x237E; 0x237F; 0x2380;
    0x2381; 0x2382; 0x2383; 0x2384; 0x2385; 0x2386; 0x2387; 0x2388; 0x2389;
    0x238A; 0x238B; 0x238C; 0x238D; 0x238E; 0x238F; 0x2390; 0x2391; 0x2392;
    0x2393; 0x2394; 0x2395; 0x2396; 0x2397; 0x2398; 0x2399; 0x239A; 0x239B;
    0x239C; 0x239D; 0x239E; 0x239F; 0x23A0; 0x23A1; 0x23A2; 0x23A3; 0x23A4;
    0x23A5; 0x23A6; 0x23A7; 0x23A8; 0x23A9; 0x23AA; 0x23AB; 0x23AC; 0x23AD;
    0x23AE; 0x23AF; 0x23B0; 0x23B1; 0x23B2; 0x23B3; 0x23B4; 0x23B5; 0x23B6;
    0x23B7; 0x23B8; 0x23B9; 0x23BA; 0x23BB; 0x23BC; 0x23BD; 0x23BE; 0x23BF;
    0x23C0; 0x23C1; 0x23C2; 0x23C3; 0x23C4; 0x23C5; 0x23C6; 0x23C7; 0x23C8;
    0x23C9; 0x23CA; 0x23CB; 0x23CC; 0x23CD; 0x23CE; 0x23CF; 0x23D0; 0x23D1;
    0x23D2; 0x23D3; 0x23D4; 0x23D5; 0x23D6; 0x23D7; 0x23D8; 0x23D9; 0x23DA;
    0x23DB; 0x23DC; 0x23DD; 0x23DE; 0x23DF; 0x23E0; 0x23E1; 0x23E2; 0x23E3;
    0x23E4; 0x23E5; 0x23E6; 0x23E7; 0x23E8; 0x23E9; 0x23EA; 0x23EB; 0x23EC;
    0x23ED; 0x23EE; 0x23EF; 0x23F0; 0x23F1; 0x23F2; 0x23F3; 0x23F4; 0x23F5;
    0x23F6; 0x23F7; 0x23F8; 0x23F9; 0x23FA; 0x23FB; 0x23FC; 0x23FD; 0x23FE;
    0x23FF; 0x2400; 0x2401; 0x2402; 0x2403; 0x2404; 0x2405; 0x2406; 0x2407;
    0x2408; 0x2409; 0x240A; 0x240B; 0x240C; 0x240D; 0x240E; 0x240F; 0x2410;
    0x2411; 0x2412; 0x2413; 0x2414; 0x2415; 0x2416; 0x2417; 0x2418; 0x2419;
    0x241A; 0x241B; 0x241C; 0x241D; 0x241E; 0x241F; 0x2420; 0x2421; 0x2422;
    0x2423; 0x2424; 0x2425; 0x2426; 0x2427; 0x2428; 0x2429; 0x2440; 0x2441;
    0x2442; 0x2443; 0x2444; 0x2445; 0x2446; 0x2447; 0x2448; 0x2449; 0x244A;
    0x249C; 0x249D; 0x249E; 0x249F; 0x24A0; 0x24A1; 0x24A2; 0x24A3; 0x24A4;
    0x24A5; 0x24A6; 0x24A7; 0x24A8; 0x24A9; 0x24AA; 0x24AB; 0x24AC; 0x24AD;
    0x24AE; 0x24AF; 0x24B0; 0x24B1; 0x24B2; 0x24B3; 0x24B4; 0x24B5; 0x24B6;
    0x24B7; 0x24B8; 0x24B9; 0x24BA; 0x24BB; 0x24BC; 0x24BD; 0x24BE; 0x24BF;
    0x24C0; 0x24C1; 0x24C2; 0x24C3; 0x24C4; 0x24C5; 0x24C6; 0x24C7; 0x24C8;
    0x24C9; 0x24CA; 0x24CB; 0x24CC; 0x24CD; 0x24CE; 0x24CF; 0x24D0; 0x24D1;
    0x24D2; 0x24D3; 0x24D4; 0x24D5; 0x24D6; 0x24D7; 0x24D8; 0x24D9; 0x24DA;
    0x24DB; 0x24DC; 0x24DD; 0x24DE; 0x24DF; 0x24E0; 0x24E1; 0x24E2; 0x24E3;
    0x24E4; 0x24E5; 0x24E6; 0x24E7; 0x24E8; 0x24E9; 0x2500; 0x2501; 0x2502;
    0x2503; 0x2504; 0x2505; 0x2506; 0x2507; 0x2508; 0x2509; 0x250A; 0x250B;
    0x250C; 0x250D; 0x250E; 0x250F; 0x2510; 0x2511; 0x2512; 0x2513; 0x2514;
    0x2515; 0x2516; 0x2517; 0x2518; 0x2519; 0x251A; 0x251B; 0x251C; 0x251D;
    0x251E; 0x251F; 0x2520; 0x2521; 0x2522; 0x2523; 0x2524; 0x2525; 0x2526;
    0x2527; 0x2528; 0x2529; 0x252A; 0x252B; 0x252C; 0x252D; 0x252E; 0x252F;
    0x2530; 0x2531; 0x2532; 0x2533; 0x2534; 0x2535; 0x2536; 0x2537; 0x2538;
    0x2539; 0x253A; 0x253B; 0x253C; 0x253D; 0x253E; 0x253F; 0x2540; 0x2541;
    0x2542; 0x2543; 0x2544; 0x2545; 0x2546; 0x2547; 0x2548; 0x2549; 0x254A;
    0x254B; 0x254C; 0x254D; 0x254E; 0x254F; 0x2550; 0x2551; 0x2552; 0x2553;
    0x2554; 0x2555; 0x2556; 0x2557; 0x2558; 0x2559; 0x255A; 0x255B; 0x255C;
    0x255D; 0x255E; 0x255F; 0x2560; 0x2561; 0x2562; 0x2563; 0x2564; 0x2565;
    0x2566; 0x2567; 0x2568; 0x2569; 0x256A; 0x256B; 0x256C; 0x256D; 0x256E;
    0x256F; 0x2570; 0x2571; 0x2572; 0x2573; 0x2574; 0x2575; 0x2576; 0x2577;
    0x2578; 0x2579; 0x257A; 0x257B; 0x257C; 0x257D; 0x257E; 0x257F; 0x2580;
    0x2581; 0x2582; 0x2583; 0x2584; 0x2585; 0x2586; 0x2587; 0x2588; 0x2589;
    0x258A; 0x258B; 0x258C; 0x258D; 0x258E; 0x258F; 0x2590; 0x2591; 0x2592;
    0x2593; 0x2594; 0x2595; 0x2596; 0x2597; 0x2598; 0x2599; 0x259A; 0x259B;
    0x259C; 0x259D; 0x259E; 0x259F; 0x25A0; 0x25A1; 0x25A2; 0x25A3; 0x25A4;
    0x25A5; 0x25A6; 0x25A7; 0x25A8; 0x25A9; 0x25AA; 0x25AB; 0x25AC; 0x25AD;
    0x25AE; 0x25AF; 0x25B0; 0x25B1; 0x25B2; 0x25B3; 0x25B4; 0x25B5; 0x25B6;
    0x25B7; 0x25B8; 0x25B9; 0x25BA; 0x25BB; 0x25BC; 0x25BD; 0x25BE; 0x25BF;
    0x25C0; 0x25C1; 0x25C2; 0x25C3; 0x25C4; 0x25C5; 0x25C6; 0x25C7; 0x25C8;
    0x25C9; 0x25CA; 0x25CB; 0x25CC; 0x25CD; 0x25CE; 0x25CF; 0x25D0; 0x25D1;
    0x25D2; 0x25D3; 0x25D4; 0x25D5; 0x25D6; 0x25D7; 0x25D8; 0x25D9; 0x25DA;
    0x25DB; 0x25DC; 0x25DD; 0x25DE; 0x25DF; 0x25E0; 0x25E1; 0x25E2; 0x25E3;
    0x25E4; 0x25E5; 0x25E6; 0x25E7; 0x25E8; 0x25E9; 0x25EA; 0x25EB; 0x25EC;
    0x25ED; 0x25EE; 0x25EF; 0x25F0; 0x25F1; 0x25F2; 0x25F3; 0x25F4; 0x25F5;
    0x25F6; 0x25F7; 0x25F8; 0x25F9; 0x25FA; 0x25FB; 0x25FC; 0x25FD; 0x25FE;
    0x25FF; 0x2600; 0x2601; 0x2602; 0x2603; 0x2604; 0x2605; 0x2606; 0x2607;
    0x2608; 0x2609; 0x260A; 0x260B; 0x260C; 0x260D; 0x260E; 0x260F; 0x2610;
    0x2611; 0x2612; 0x2613; 0x2614; 0x2615; 0x2616; 0x2617; 0x2618; 0x2619;
    0x261A; 0x261B; 0x261C; 0x261D; 0x261E; 0x261F; 0x2620; 0x2621; 0x2622;
    0x2623; 0x2624; 0x2625; 0x2626; 0x2627; 0x2628; 0x2629; 0x262A; 0x262B;
    0x262C; 0x262D; 0x262E; 0x262F; 0x2630; 0x2631; 0x2632; 0x2633; 0x2634;
    0x2635; 0x2636; 0x2637; 0x2638; 0x2639; 0x263A; 0x263B; 0x263C; 0x263D;
    0x263E; 0x263F; 0x2640; 0x2641; 0x2642; 0x2643; 0x2644; 0x2645; 0x2646;
    0x2647; 0x2648; 0x2649; 0x264A; 0x264B; 0x264C; 0x264D; 0x264E; 0x264F;
    0x2650; 0x2651; 0x2652; 0x2653; 0x2654; 0x2655; 0x2656; 0x2657; 0x2658;
    0x2659; 0x265A; 0x265B; 0x265C; 0x265D; 0x265E; 0x265F; 0x2660; 0x2661;
    0x2662; 0x2663; 0x2664; 0x2665; 0x2666; 0x2667; 0x2668; 0x2669; 0x266A;
    0x266B; 0x266C; 0x266D; 0x266E; 0x266F; 0x2670; 0x2671; 0x2672; 0x2673;
    0x2674; 0x2675; 0x2676; 0x2677; 0x2678; 0x2679; 0x267A; 0x267B; 0x267C;
    0x267D; 0x267E; 0x267F; 0x2680; 0x2681; 0x2682; 0x2683; 0x2684; 0x2685;
    0x2686; 0x2687; 0x2688; 0x2689; 0x268A; 0x268B; 0x268C; 0x268D; 0x268E;
    0x268F; 0x2690; 0x2691; 0x2692; 0x2693; 0x2694; 0x2695; 0x2696; 0x2697;
    0x2698; 0x2699; 0x269A; 0x269B; 0x269C; 0x269D; 0x269E; 0x269F; 0x26A0;
    0x26A1; 0x26A2; 0x26A3; 0x26A4; 0x26A5; 0x26A6; 0x26A7; 0x26A8; 0x26A9;
    0x26AA; 0x26AB; 0x26AC; 0x26AD; 0x26AE; 0x26AF; 0x26B0; 0x26B1; 0x26B2;
    0x26B3; 0x26B4; 0x26B5; 0x26B6; 0x26B7; 0x26B8; 0x26B9; 0x26BA; 0x26BB;
    0x26BC; 0x26BD; 0x26BE; 0x26BF; 0x26C0; 0x26C1; 0x26C2; 0x26C3; 0x26C4;
    0x26C5; 0x26C6; 0x26C7; 0x26C8; 0x26C9; 0x26CA; 0x26CB; 0x26CC; 0x26CD;
    0x26CE; 0x26CF; 0x26D0; 0x26D1; 0x26D2; 0x26D3; 0x26D4; 0x26D5; 0x26D6;
    0x26D7; 0x26D8; 0x26D9; 0x26DA; 0x26DB; 0x26DC; 0x26DD; 0x26DE; 0x26DF;
    0x26E0; 0x26E1; 0x26E2; 0x26E3; 0x26E4; 0x26E5; 0x26E6; 0x26E7; 0x26E8;
    0x26E9; 0x26EA; 0x26EB; 0x26EC; 0x26ED; 0x26EE; 0x26EF; 0x26F0; 0x26F1;
    0x26F2; 0x26F3; 0x26F4; 0x26F5; 0x26F6; 0x26F7; 0x26F8; 0x26F9; 0x26FA;
    0x26FB; 0x26FC; 0x26FD; 0x26FE; 0x26FF; 0x2700; 0x2701; 0x2702; 0x2703;
    0x2704; 0x2705; 0x2706; 0x2707; 0x2708; 0x2709; 0x270A; 0x270B; 0x270C;
    0x270D; 0x270E; 0x270F; 0x2710; 0x2711; 0x2712; 0x2713; 0x2714; 0x2715;
    0x2716; 0x2717; 0x2718; 0x2719; 0x271A; 0x271B; 0x271C; 0x271D; 0x271E;
    0x271F; 0x2720; 0x2721; 0x2722; 0x2723; 0x2724; 0x2725; 0x2726; 0x2727;
    0x2728; 0x2729; 0x272A; 0x272B; 0x272C; 0x272D; 0x272E; 0x272F; 0x2730;
    0x2731; 0x2732; 0x2733; 0x2734; 0x2735; 0x2736; 0x2737; 0x2738; 0x2739;
    0x273A; 0x273B; 0x273C; 0x273D; 0x273E; 0x273F; 0x2740; 0x2741; 0x2742;
    0x2743; 0x2744; 0x2745; 0x2746; 0x2747; 0x2748; 0x2749; 0x274A; 0x274B;
    0x274C; 0x274D; 0x274E; 0x274F; 0x2750; 0x2751; 0x2752; 0x2753; 0x2754;
    0x2755; 0x2756; 0x2757; 0x2758; 0x2759; 0x275A; 0x275B; 0x275C; 0x275D;
    0x275E; 0x275F; 0x2760; 0x2761; 0x2762; 0x2763; 0x2764; 0x2765; 0x2766;
    0x2767; 0x2768; 0x2769; 0x276A; 0x276B; 0x276C; 0x276D; 0x276E; 0x276F;
    0x2770; 0x2771; 0x2772; 0x2773; 0x2774; 0x2775; 0x2794; 0x2795; 0x2796;
    0x2797; 0x2798; 0x2799; 0x279A; 0x279B; 0x279C; 0x279D; 0x279E; 0x279F;
    0x27A0; 0x27A1; 0x27A2; 0x27A3; 0x27A4; 0x27A5; 0x27A6; 0x27A7; 0x27A8;
    0x27A9; 0x27AA; 0x27AB; 0x27AC; 0x27AD; 0x27AE; 0x27AF; 0x27B0; 0x27B1;
    0x27B2; 0x27B3; 0x27B4; 0x27B5; 0x27B6; 0x27B7; 0x27B8; 0x27B9; 0x27BA;
    0x27BB; 0x27BC; 0x27BD; 0x27BE; 0x27BF; 0x27C0; 0x27C1; 0x27C2; 0x27C3;
    0x27C4; 0x27C5; 0x27C6; 0x27C7; 0x27C8; 0x27C9; 0x27CA; 0x27CB; 0x27CC;
    0x27CD; 0x27CE; 0x27CF; 0x27D0; 0x27D1; 0x27D2; 0x27D3; 0x27D4; 0x27D5;
    0x27D6; 0x27D7; 0x27D8; 0x27D9; 0x27DA; 0x27DB; 0x27DC; 0x27DD; 0x27DE;
    0x27DF; 0x27E0; 0x27E1; 0x27E2; 0x27E3; 0x27E4; 0x27E5; 0x27E6; 0x27E7;
    0x27E8; 0x27E9; 0x27EA; 0x27EB; 0x27EC; 0x27ED; 0x27EE; 0x27EF; 0x27F0;
    0x27F1; 0x27F2; 0x27F3; 0x27F4; 0x27F5; 0x27F6; 0x27F7; 0x27F8; 0x27F9;
    0x27FA; 0x27FB; 0x27FC; 0x27FD; 0x27FE; 0x27FF; 0x2800; 0x2801; 0x2802;
    0x2803; 0x2804; 0x2805; 0x2806; 0x2807; 0x2808; 0x2809; 0x280A; 0x280B;
    0x280C; 0x280D; 0x280E; 0x280F; 0x2810; 0x2811; 0x2812; 0x2813; 0x2814;
    0x2815; 0x2816; 0x2817; 0x2818; 0x2819; 0x281A; 0x281B; 0x281C; 0x281D;
    0x281E; 0x281F; 0x2820; 0x2821; 0x2822; 0x2823; 0x2824; 0x2825; 0x2826;
    0x2827; 0x2828; 0x2829; 0x282A; 0x282B; 0x282C; 0x282D; 0x282E; 0x282F;
    0x2830; 0x2831; 0x2832; 0x2833; 0x2834; 0x2835; 0x2836; 0x2837; 0x2838;
    0x2839; 0x283A; 0x283B; 0x283C; 0x283D; 0x283E; 0x283F; 0x2840; 0x2841;
    0x2842; 0x2843; 0x2844; 0x2845; 0x2846; 0x2847; 0x2848; 0x2849; 0x284A;
    0x284B; 0x284C; 0x284D; 0x284E; 0x284F; 0x2850; 0x2851; 0x2852; 0x2853;
    0x2854; 0x2855; 0x2856; 0x2857; 0x2858; 0x2859; 0x285A; 0x285B; 0x285C;
    0x285D; 0x285E; 0x285F; 0x2860; 0x2861; 0x2862; 0x2863; 0x2864; 0x2865;
    0x2866; 0x2867; 0x2868; 0x2869; 0x286A; 0x286B; 0x286C; 0x286D; 0x286E;
    0x286F; 0x2870; 0x2871; 0x2872; 0x2873; 0x2874; 0x2875; 0x2876; 0x2877;
    0x2878; 0x2879; 0x287A; 0x287B; 0x287C; 0x287D; 0x287E; 0x287F; 0x2880;
    0x2881; 0x2882; 0x2883; 0x2884; 0x2885; 0x2886; 0x2887; 0x2888; 0x2889;
    0x288A; 0x288B; 0x288C; 0x288D; 0x288E; 0x288F; 0x2890; 0x2891; 0x2892;
    0x2893; 0x2894; 0x2895; 0x2896; 0x2897; 0x2898; 0x2899; 0x289A; 0x289B;
    0x289C; 0x289D; 0x289E; 0x289F; 0x28A0; 0x28A1; 0x28A2; 0x28A3; 0x28A4;
    0x28A5; 0x28A6; 0x28A7; 0x28A8; 0x28A9; 0x28AA; 0x28AB; 0x28AC; 0x28AD;
    0x28AE; 0x28AF; 0x28B0; 0x28B1; 0x28B2; 0x28B3; 0x28B4; 0x28B5; 0x28B6;
    0x28B7; 0x28B8; 0x28B9; 0x28BA; 0x28BB; 0x28BC; 0x28BD; 0x28BE; 0x28BF;
    0x28C0; 0x28C1; 0x28C2; 0x28C3; 0x28C4; 0x28C5; 0x28C6; 0x28C7; 0x28C8;
    0x28C9; 0x28CA; 0x28CB; 0x28CC; 0x28CD; 0x28CE; 0x28CF; 0x28D0; 0x28D1;
    0x28D2; 0x28D3; 0x28D4; 0x28D5; 0x28D6; 0x28D7; 0x28D8; 0x28D9; 0x28DA;
    0x28DB; 0x28DC; 0x28DD; 0x28DE; 0x28DF; 0x28E0; 0x28E1; 0x28E2; 0x28E3;
    0x28E4; 0x28E5; 0x28E6; 0x28E7; 0x28E8; 0x28E9; 0x28EA; 0x28EB; 0x28EC;
    0x28ED; 0x28EE; 0x28EF; 0x28F0; 0x28F1; 0x28F2; 0x28F3; 0x28F4; 0x28F5;
    0x28F6; 0x28F7; 0x28F8; 0x28F9; 0x28FA; 0x28FB; 0x28FC; 0x28FD; 0x28FE;
    0x28FF; 0x2900; 0x2901; 0x2902; 0x2903; 0x2904; 0x2905; 0x2906; 0x2907;
    0x2908; 0x2909; 0x290A; 0x290B; 0x290C; 0x290D; 0x290E; 0x290F; 0x2910;
    0x2911; 0x2912; 0x2913; 0x2914; 0x2915; 0x2916; 0x2917; 0x2918; 0x2919;
    0x291A; 0x291B; 0x291C; 0x291D; 0x291E; 0x291F; 0x2920; 0x2921; 0x2922;
    0x2923; 0x2924; 0x2925; 0x2926; 0x2927; 0x2928; 0x2929; 0x292A; 0x292B;
    0x292C; 0x292D; 0x292E; 0x292F; 0x2930; 0x2931; 0x2932; 0x2933; 0x2934;
    0x2935; 0x2936; 0x2937; 0x2938; 0x2939; 0x293A; 0x293B; 0x293C; 0x293D;
    0x293E; 0x293F; 0x2940; 0x2941; 0x2942; 0x2943; 0x2944; 0x2945; 0x2946;
    0x2947; 0x2948; 0x2949; 0x294A; 0x294B; 0x294C; 0x294D; 0x294E; 0x294F;
    0x2950; 0x2951; 0x2952; 0x2953; 0x2954; 0x2955; 0x2956; 0x2957; 0x2958;
    0x2959; 0x295A; 0x295B; 0x295C; 0x295D; 0x295E; 0x295F; 0x2960; 0x2961;
    0x2962; 0x2963; 0x2964; 0x2965; 0x2966; 0x2967; 0x2968; 0x2969; 0x296A;
    0x296B; 0x296C; 0x296D; 0x296E; 0x296F; 0x2970; 0x2971; 0x2972; 0x2973;
    0x2974; 0x2975; 0x2976; 0x2977; 0x2978; 0x2979; 0x297A; 0x297B; 0x297C;
    0x297D; 0x297E; 0x297F; 0x2980; 0x2981; 0x2982; 0x2983; 0x2984; 0x2985;
    0x2986; 0x2987; 0x2988; 0x2989; 0x298A; 0x298B; 0x298C; 0x298D; 0x298E;
    0x298F; 0x2990; 0x2991; 0x2992; 0x2993; 0x2994; 0x2995; 0x2996; 0x2997;
    0x2998; 0x2999; 0x299A; 0x299B; 0x299C; 0x299D; 0x299E; 0x299F; 0x29A0;
    0x29A1; 0x29A2; 0x29A3; 0x29A4; 0x29A5; 0x29A6; 0x29A7; 0x29A8; 0x29A9;
    0x29AA; 0x29AB; 0x29AC; 0x29AD; 0x29AE; 0x29AF; 0x29B0; 0x29B1; 0x29B2;
    0x29B3; 0x29B4; 0x29B5; 0x29B6; 0x29B7; 0x29B8; 0x29B9; 0x29BA; 0x29BB;
    0x29BC; 0x29BD; 0x29BE; 0x29BF; 0x29C0; 0x29C1; 0x29C2; 0x29C3; 0x29C4;
    0x29C5; 0x29C6; 0x29C7; 0x29C8; 0x29C9; 0x29CA; 0x29CB; 0x29CC; 0x29CD;
    0x29CE; 0x29CF; 0x29D0; 0x29D1; 0x29D2; 0x29D3; 0x29D4; 0x29D5; 0x29D6;
    0x29D7; 0x29D8; 0x29D9; 0x29DA; 0x29DB; 0x29DC; 0x29DD; 0x29DE; 0x29DF;
    0x29E0; 0x29E1; 0x29E2; 0x29E3; 0x29E4; 0x29E5; 0x29E6; 0x29E7; 0x29E8;
    0x29E9; 0x29EA; 0x29EB; 0x29EC; 0x29ED; 0x29EE; 0x29EF; 0x29F0; 0x29F1;
    0x29F2; 0x29F3; 0x29F4; 0x29F5; 0x29F6; 0x29F7; 0x29F8; 0x29F9; 0x29FA;
    0x29FB; 0x29FC; 0x29FD; 0x29FE; 0x29FF; 0x2A00; 0x2A01; 0x2A02; 0x2A03;
    0x2A04; 0x2A05; 0x2A06; 0x2A07; 0x2A08; 0x2A09; 0x2A0A; 0x2A0B; 0x2A0C;
    0x2A0D; 0x2A0E; 0x2A0F; 0x2A10; 0x2A11; 0x2A12; 0x2A13; 0x2A14; 0x2A15;
    0x2A16; 0x2A17; 0x2A18; 0x2A19; 0x2A1A; 0x2A1B; 0x2A1C; 0x2A1D; 0x2A1E;
    0x2A1F; 0x2A20; 0x2A21; 0x2A22; 0x2A23; 0x2A24; 0x2A25; 0x2A26; 0x2A27;
    0x2A28; 0x2A29; 0x2A2A; 0x2A2B; 0x2A2C; 0x2A2D; 0x2A2E; 0x2A2F; 0x2A30;
    0x2A31; 0x2A32; 0x2A33; 0x2A34; 0x2A35; 0x2A36; 0x2A37; 0x2A38; 0x2A39;
    0x2A3A; 0x2A3B; 0x2A3C; 0x2A3D; 0x2A3E; 0x2A3F; 0x2A40; 0x2A41; 0x2A42;
    0x2A43; 0x2A44; 0x2A45; 0x2A46; 0x2A47; 0x2A48; 0x2A49; 0x2A4A; 0x2A4B;
    0x2A4C; 0x2A4D; 0x2A4E; 0x2A4F; 0x2A50; 0x2A51; 0x2A52; 0x2A53; 0x2A54;
    0x2A55; 0x2A56; 0x2A57; 0x2A58; 0x2A59; 0x2A5A; 0x2A5B; 0x2A5C; 0x2A5D;
    0x2A5E; 0x2A5F; 0x2A60; 0x2A61; 0x2A62; 0x2A63; 0x2A64; 0x2A65; 0x2A66;
    0x2A67; 0x2A68; 0x2A69; 0x2A6A; 0x2A6B; 0x2A6C; 0x2A6D; 0x2A6E; 0x2A6F;
    0x2A70; 0x2A71; 0x2A72; 0x2A73; 0x2A74; 0x2A75; 0x2A76; 0x2A77; 0x2A78;
    0x2A79; 0x2A7A; 0x2A7B; 0x2A7C; 0x2A7D; 0x2A7E; 0x2A7F; 0x2A80; 0x2A81;
    0x2A82; 0x2A83; 0x2A84; 0x2A85; 0x2A86; 0x2A87; 0x2A88; 0x2A89; 0x2A8A;
    0x2A8B; 0x2A8C; 0x2A8D; 0x2A8E; 0x2A8F; 0x2A90; 0x2A91; 0x2A92; 0x2A93;
    0x2A94; 0x2A95; 0x2A96; 0x2A97; 0x2A98; 0x2A99; 0x2A9A; 0x2A9B; 0x2A9C;
    0x2A9D; 0x2A9E; 0x2A9F; 0x2AA0; 0x2AA1; 0x2AA2; 0x2AA3; 0x2AA4; 0x2AA5;
    0x2AA6; 0x2AA7; 0x2AA8; 0x2AA9; 0x2AAA; 0x2AAB; 0x2AAC; 0x2AAD; 0x2AAE;
    0x2AAF; 0x2AB0; 0x2AB1; 0x2AB2; 0x2AB3; 0x2AB4; 0x2AB5; 0x2AB6; 0x2AB7;
    0x2AB8; 0x2AB9; 0x2ABA; 0x2ABB; 0x2ABC; 0x2ABD; 0x2ABE; 0x2ABF; 0x2AC0;
    0x2AC1; 0x2AC2; 0x2AC3; 0x2AC4; 0x2AC5; 0x2AC6; 0x2AC7; 0x2AC8; 0x2AC9;
    0x2ACA; 0x2ACB; 0x2ACC; 0x2ACD; 0x2ACE; 0x2ACF; 0x2AD0; 0x2AD1; 0x2AD2;
    0x2AD3; 0x2AD4; 0x2AD5; 0x2AD6; 0x2AD7; 0x2AD8; 0x2AD9; 0x2ADA; 0x2ADB;
    0x2ADC; 0x2ADD; 0x2ADE; 0x2ADF; 0x2AE0; 0x2AE1; 0x2AE2; 0x2AE3; 0x2AE4;
    0x2AE5; 0x2AE6; 0x2AE7; 0x2AE8; 0x2AE9; 0x2AEA; 0x2AEB; 0x2AEC; 0x2AED;
    0x2AEE; 0x2AEF; 0x2AF0; 0x2AF1; 0x2AF2; 0x2AF3; 0x2AF4; 0x2AF5; 0x2AF6;
    0x2AF7; 0x2AF8; 0x2AF9; 0x2AFA; 0x2AFB; 0x2AFC; 0x2AFD; 0x2AFE; 0x2AFF;
    0x2B00; 0x2B01; 0x2B02; 0x2B03; 0x2B04; 0x2B05; 0x2B06; 0x2B07; 0x2B08;
    0x2B09; 0x2B0A; 0x2B0B; 0x2B0C; 0x2B0D; 0x2B0E; 0x2B0F; 0x2B10; 0x2B11;
    0x2B12; 0x2B13; 0x2B14; 0x2B15; 0x2B16; 0x2B17; 0x2B18; 0x2B19; 0x2B1A;
    0x2B1B; 0x2B1C; 0x2B1D; 0x2B1E; 0x2B1F; 0x2B20; 0x2B21; 0x2B22; 0x2B23;
    0x2B24; 0x2B25; 0x2B26; 0x2B27; 0x2B28; 0x2B29; 0x2B2A; 0x2B2B; 0x2B2C;
    0x2B2D; 0x2B2E; 0x2B2F; 0x2B30; 0x2B31; 0x2B32; 0x2B33; 0x2B34; 0x2B35;
    0x2B36; 0x2B37; 0x2B38; 0x2B39; 0x2B3A; 0x2B3B; 0x2B3C; 0x2B3D; 0x2B3E;
    0x2B3F; 0x2B40; 0x2B41; 0x2B42; 0x2B43; 0x2B44; 0x2B45; 0x2B46; 0x2B47;
    0x2B48; 0x2B49; 0x2B4A; 0x2B4B; 0x2B4C; 0x2B4D; 0x2B4E; 0x2B4F; 0x2B50;
    0x2B51; 0x2B52; 0x2B53; 0x2B54; 0x2B55; 0x2B56; 0x2B57; 0x2B58; 0x2B59;
    0x2B5A; 0x2B5B; 0x2B5C; 0x2B5D; 0x2B5E; 0x2B5F; 0x2B60; 0x2B61; 0x2B62;
    0x2B63; 0x2B64; 0x2B65; 0x2B66; 0x2B67; 0x2B68; 0x2B69; 0x2B6A; 0x2B6B;
    0x2B6C; 0x2B6D; 0x2B6E; 0x2B6F; 0x2B70; 0x2B71; 0x2B72; 0x2B73; 0x2B76;
    0x2B77; 0x2B78; 0x2B79; 0x2B7A; 0x2B7B; 0x2B7C; 0x2B7D; 0x2B7E; 0x2B7F;
    0x2B80; 0x2B81; 0x2B82; 0x2B83; 0x2B84; 0x2B85; 0x2B86; 0x2B87; 0x2B88;
    0x2B89; 0x2B8A; 0x2B8B; 0x2B8C; 0x2B8D; 0x2B8E; 0x2B8F; 0x2B90; 0x2B91;
    0x2B92; 0x2B93; 0x2B94; 0x2B95; 0x2B96; 0x2B97; 0x2B98; 0x2B99; 0x2B9A;
    0x2B9B; 0x2B9C; 0x2B9D; 0x2B9E; 0x2B9F; 0x2BA0; 0x2BA1; 0x2BA2; 0x2BA3;
    0x2BA4; 0x2BA5; 0x2BA6; 0x2BA7; 0x2BA8; 0x2BA9; 0x2BAA; 0x2BAB; 0x2BAC;
    0x2BAD; 0x2BAE; 0x2BAF; 0x2BB0; 0x2BB1; 0x2BB2; 0x2BB3; 0x2BB4; 0x2BB5;
    0x2BB6; 0x2BB7; 0x2BB8; 0x2BB9; 0x2BBA; 0x2BBB; 0x2BBC; 0x2BBD; 0x2BBE;
    0x2BBF; 0x2BC0; 0x2BC1; 0x2BC2; 0x2BC3; 0x2BC4; 0x2BC5; 0x2BC6; 0x2BC7;
    0x2BC8; 0x2BC9; 0x2BCA; 0x2BCB; 0x2BCC; 0x2BCD; 0x2BCE; 0x2BCF; 0x2BD0;
    0x2BD1; 0x2BD2; 0x2BD3; 0x2BD4; 0x2BD5; 0x2BD6; 0x2BD7; 0x2BD8; 0x2BD9;
    0x2BDA; 0x2BDB; 0x2BDC; 0x2BDD; 0x2BDE; 0x2BDF; 0x2BE0; 0x2BE1; 0x2BE2;
    0x2BE3; 0x2BE4; 0x2BE5; 0x2BE6; 0x2BE7; 0x2BE8; 0x2BE9; 0x2BEA; 0x2BEB;
    0x2BEC; 0x2BED; 0x2BEE; 0x2BEF; 0x2BF0; 0x2BF1; 0x2BF2; 0x2BF3; 0x2BF4;
    0x2BF5; 0x2BF6; 0x2BF7; 0x2BF8; 0x2BF9; 0x2BFA; 0x2BFB; 0x2BFC; 0x2BFD;
    0x2BFE; 0x2BFF; 0x2CE5; 0x2CE6; 0x2CE7; 0x2CE8; 0x2CE9; 0x2CEA; 0x2CF9;
    0x2CFA; 0x2CFB; 0x2CFC; 0x2CFE; 0x2CFF; 0x2D70; 0x2E00; 0x2E01; 0x2E02;
    0x2E03; 0x2E04; 0x2E05; 0x2E06; 0x2E07; 0x2E08; 0x2E09; 0x2E0A; 0x2E0B;
    0x2E0C; 0x2E0D; 0x2E0E; 0x2E0F; 0x2E10; 0x2E11; 0x2E12; 0x2E13; 0x2E14;
    0x2E15; 0x2E16; 0x2E17; 0x2E18; 0x2E19; 0x2E1A; 0x2E1B; 0x2E1C; 0x2E1D;
    0x2E1E; 0x2E1F; 0x2E20; 0x2E21; 0x2E22; 0x2E23; 0x2E24; 0x2E25; 0x2E26;
    0x2E27; 0x2E28; 0x2E29; 0x2E2A; 0x2E2B; 0x2E2C; 0x2E2D; 0x2E2E; 0x2E30;
    0x2E31; 0x2E32; 0x2E33; 0x2E34; 0x2E35; 0x2E36; 0x2E37; 0x2E38; 0x2E39;
    0x2E3A; 0x2E3B; 0x2E3C; 0x2E3D; 0x2E3E; 0x2E3F; 0x2E40; 0x2E41; 0x2E42;
    0x2E43; 0x2E44; 0x2E45; 0x2E46; 0x2E47; 0x2E48; 0x2E49; 0x2E4A; 0x2E4B;
    0x2E4C; 0x2E4D; 0x2E4E; 0x2E4F; 0x2E50; 0x2E51; 0x2E52; 0x2E53; 0x2E54;
    0x2E55; 0x2E56; 0x2E57; 0x2E58; 0x2E59; 0x2E5A; 0x2E5B; 0x2E5C; 0x2E5D;
    0x2E80; 0x2E81; 0x2E82; 0x2E83; 0x2E84; 0x2E85; 0x2E86; 0x2E87; 0x2E88;
    0x2E89; 0x2E8A; 0x2E8B; 0x2E8C; 0x2E8D; 0x2E8E; 0x2E8F; 0x2E90; 0x2E91;
    0x2E92; 0x2E93; 0x2E94; 0x2E95; 0x2E96; 0x2E97; 0x2E98; 0x2E99; 0x2E9B;
    0x2E9C; 0x2E9D; 0x2E9E; 0x2E9F; 0x2EA0; 0x2EA1; 0x2EA2; 0x2EA3; 0x2EA4;
    0x2EA5; 0x2EA6; 0x2EA7; 0x2EA8; 0x2EA9; 0x2EAA; 0x2EAB; 0x2EAC; 0x2EAD;
    0x2EAE; 0x2EAF; 0x2EB0; 0x2EB1; 0x2EB2; 0x2EB3; 0x2EB4; 0x2EB5; 0x2EB6;
    0x2EB7; 0x2EB8; 0x2EB9; 0x2EBA; 0x2EBB; 0x2EBC; 0x2EBD; 0x2EBE; 0x2EBF;
    0x2EC0; 0x2EC1; 0x2EC2; 0x2EC3; 0x2EC4; 0x2EC5; 0x2EC6; 0x2EC7; 0x2EC8;
    0x2EC9; 0x2ECA; 0x2ECB; 0x2ECC; 0x2ECD; 0x2ECE; 0x2ECF; 0x2ED0; 0x2ED1;
    0x2ED2; 0x2ED3; 0x2ED4; 0x2ED5; 0x2ED6; 0x2ED7; 0x2ED8; 0x2ED9; 0x2EDA;
    0x2EDB; 0x2EDC; 0x2EDD; 0x2EDE; 0x2EDF; 0x2EE0; 0x2EE1; 0x2EE2; 0x2EE3;
    0x2EE4; 0x2EE5; 0x2EE6; 0x2EE7; 0x2EE8; 0x2EE9; 0x2EEA; 0x2EEB; 0x2EEC;
    0x2EED; 0x2EEE; 0x2EEF; 0x2EF0; 0x2EF1; 0x2EF2; 0x2EF3; 0x2F00; 0x2F01;
    0x2F02; 0x2F03; 0x2F04; 0x2F05; 0x2F06; 0x2F07; 0x2F08; 0x2F09; 0x2F0A;
    0x2F0B; 0x2F0C; 0x2F0D; 0x2F0E; 0x2F0F; 0x2F10; 0x2F11; 0x2F12; 0x2F13;
    0x2F14; 0x2F15; 0x2F16; 0x2F17; 0x2F18; 0x2F19; 0x2F1A; 0x2F1B; 0x2F1C;
    0x2F1D; 0x2F1E; 0x2F1F; 0x2F20; 0x2F21; 0x2F22; 0x2F23; 0x2F24; 0x2F25;
    0x2F26; 0x2F27; 0x2F28; 0x2F29; 0x2F2A; 0x2F2B; 0x2F2C; 0x2F2D; 0x2F2E;
    0x2F2F; 0x2F30; 0x2F31; 0x2F32; 0x2F33; 0x2F34; 0x2F35; 0x2F36; 0x2F37;
    0x2F38; 0x2F39; 0x2F3A; 0x2F3B; 0x2F3C; 0x2F3D; 0x2F3E; 0x2F3F; 0x2F40;
    0x2F41; 0x2F42; 0x2F43; 0x2F44; 0x2F45; 0x2F46; 0x2F47; 0x2F48; 0x2F49;
    0x2F4A; 0x2F4B; 0x2F4C; 0x2F4D; 0x2F4E; 0x2F4F; 0x2F50; 0x2F51; 0x2F52;
    0x2F53; 0x2F54; 0x2F55; 0x2F56; 0x2F57; 0x2F58; 0x2F59; 0x2F5A; 0x2F5B;
    0x2F5C; 0x2F5D; 0x2F5E; 0x2F5F; 0x2F60; 0x2F61; 0x2F62; 0x2F63; 0x2F64;
    0x2F65; 0x2F66; 0x2F67; 0x2F68; 0x2F69; 0x2F6A; 0x2F6B; 0x2F6C; 0x2F6D;
    0x2F6E; 0x2F6F; 0x2F70; 0x2F71; 0x2F72; 0x2F73; 0x2F74; 0x2F75; 0x2F76;
    0x2F77; 0x2F78; 0x2F79; 0x2F7A; 0x2F7B; 0x2F7C; 0x2F7D; 0x2F7E; 0x2F7F;
    0x2F80; 0x2F81; 0x2F82; 0x2F83; 0x2F84; 0x2F85; 0x2F86; 0x2F87; 0x2F88;
    0x2F89; 0x2F8A; 0x2F8B; 0x2F8C; 0x2F8D; 0x2F8E; 0x2F8F; 0x2F90; 0x2F91;
    0x2F92; 0x2F93; 0x2F94; 0x2F95; 0x2F96; 0x2F97; 0x2F98; 0x2F99; 0x2F9A;
    0x2F9B; 0x2F9C; 0x2F9D; 0x2F9E; 0x2F9F; 0x2FA0; 0x2FA1; 0x2FA2; 0x2FA3;
    0x2FA4; 0x2FA5; 0x2FA6; 0x2FA7; 0x2FA8; 0x2FA9; 0x2FAA; 0x2FAB; 0x2FAC;
    0x2FAD; 0x2FAE; 0x2FAF; 0x2FB0; 0x2FB1; 0x2FB2; 0x2FB3; 0x2FB4; 0x2FB5;
    0x2FB6; 0x2FB7; 0x2FB8; 0x2FB9; 0x2FBA; 0x2FBB; 0x2FBC; 0x2FBD; 0x2FBE;
    0x2FBF; 0x2FC0; 0x2FC1; 0x2FC2; 0x2FC3; 0x2FC4; 0x2FC5; 0x2FC6; 0x2FC7;
    0x2FC8; 0x2FC9; 0x2FCA; 0x2FCB; 0x2FCC; 0x2FCD; 0x2FCE; 0x2FCF; 0x2FD0;
    0x2FD1; 0x2FD2; 0x2FD3; 0x2FD4; 0x2FD5; 0x2FF0; 0x2FF1; 0x2FF2; 0x2FF3;
    0x2FF4; 0x2FF5; 0x2FF6; 0x2FF7; 0x2FF8; 0x2FF9; 0x2FFA; 0x2FFB; 0x2FFC;
    0x2FFD; 0x2FFE; 0x2FFF; 0x3001; 0x3002; 0x3003; 0x3004; 0x3008; 0x3009;
    0x300A; 0x300B; 0x300C; 0x300D; 0x300E; 0x300F; 0x3010; 0x3011; 0x3012;
    0x3013; 0x3014; 0x3015; 0x3016; 0x3017; 0x3018; 0x3019; 0x301A; 0x301B;
    0x301C; 0x301D; 0x301E; 0x301F; 0x3020; 0x3030; 0x3036; 0x3037; 0x303D;
    0x303E; 0x303F; 0x309B; 0x309C; 0x30A0; 0x30FB; 0x3190; 0x3191; 0x3196;
    0x3197; 0x3198; 0x3199; 0x319A; 0x319B; 0x319C; 0x319D; 0x319E; 0x319F;
    0x31C0; 0x31C1; 0x31C2; 0x31C3; 0x31C4; 0x31C5; 0x31C6; 0x31C7; 0x31C8;
    0x31C9; 0x31CA; 0x31CB; 0x31CC; 0x31CD; 0x31CE; 0x31CF; 0x31D0; 0x31D1;
    0x31D2; 0x31D3; 0x31D4; 0x31D5; 0x31D6; 0x31D7; 0x31D8; 0x31D9; 0x31DA;
    0x31DB; 0x31DC; 0x31DD; 0x31DE; 0x31DF; 0x31E0; 0x31E1; 0x31E2; 0x31E3;
    0x31E4; 0x31E5; 0x31EF; 0x3200; 0x3201; 0x3202; 0x3203; 0x3204; 0x3205;
    0x3206; 0x3207; 0x3208; 0x3209; 0x320A; 0x320B; 0x320C; 0x320D; 0x320E;
    0x320F; 0x3210; 0x3211; 0x3212; 0x3213; 0x3214; 0x3215; 0x3216; 0x3217;
    0x3218; 0x3219; 0x321A; 0x321B; 0x321C; 0x321D; 0x321E; 0x322A; 0x322B;
    0x322C; 0x322D; 0x322E; 0x322F; 0x3230; 0x3231; 0x3232; 0x3233; 0x3234;
    0x3235; 0x3236; 0x3237; 0x3238; 0x3239; 0x323A; 0x323B; 0x323C; 0x323D;
    0x323E; 0x323F; 0x3240; 0x3241; 0x3242; 0x3243; 0x3244; 0x3245; 0x3246;
    0x3247; 0x3250; 0x3260; 0x3261; 0x3262; 0x3263; 0x3264; 0x3265; 0x3266;
    0x3267; 0x3268; 0x3269; 0x326A; 0x326B; 0x326C; 0x326D; 0x326E; 0x326F;
    0x3270; 0x3271; 0x3272; 0x3273; 0x3274; 0x3275; 0x3276; 0x3277; 0x3278;
    0x3279; 0x327A; 0x327B; 0x327C; 0x327D; 0x327E; 0x327F; 0x328A; 0x328B;
    0x328C; 0x328D; 0x328E; 0x328F; 0x3290; 0x3291; 0x3292; 0x3293; 0x3294;
    0x3295; 0x3296; 0x3297; 0x3298; 0x3299; 0x329A; 0x329B; 0x329C; 0x329D;
    0x329E; 0x329F; 0x32A0; 0x32A1; 0x32A2; 0x32A3; 0x32A4; 0x32A5; 0x32A6;
    0x32A7; 0x32A8; 0x32A9; 0x32AA; 0x32AB; 0x32AC; 0x32AD; 0x32AE; 0x32AF;
    0x32B0; 0x32C0; 0x32C1; 0x32C2; 0x32C3; 0x32C4; 0x32C5; 0x32C6; 0x32C7;
    0x32C8; 0x32C9; 0x32CA; 0x32CB; 0x32CC; 0x32CD; 0x32CE; 0x32CF; 0x32D0;
    0x32D1; 0x32D2; 0x32D3; 0x32D4; 0x32D5; 0x32D6; 0x32D7; 0x32D8; 0x32D9;
    0x32DA; 0x32DB; 0x32DC; 0x32DD; 0x32DE; 0x32DF; 0x32E0; 0x32E1; 0x32E2;
    0x32E3; 0x32E4; 0x32E5; 0x32E6; 0x32E7; 0x32E8; 0x32E9; 0x32EA; 0x32EB;
    0x32EC; 0x32ED; 0x32EE; 0x32EF; 0x32F0; 0x32F1; 0x32F2; 0x32F3; 0x32F4;
    0x32F5; 0x32F6; 0x32F7; 0x32F8; 0x32F9; 0x32FA; 0x32FB; 0x32FC; 0x32FD;
    0x32FE; 0x32FF; 0x3300; 0x3301; 0x3302; 0x3303; 0x3304; 0x3305; 0x3306;
    0x3307; 0x3308; 0x3309; 0x330A; 0x330B; 0x330C; 0x330D; 0x330E; 0x330F;
    0x3310; 0x3311; 0x3312; 0x3313; 0x3314; 0x3315; 0x3316; 0x3317; 0x3318;
    0x3319; 0x331A; 0x331B; 0x331C; 0x331D; 0x331E; 0x331F; 0x3320; 0x3321;
    0x3322; 0x3323; 0x3324; 0x3325; 0x3326; 0x3327; 0x3328; 0x3329; 0x332A;
    0x332B; 0x332C; 0x332D; 0x332E; 0x332F; 0x3330; 0x3331; 0x3332; 0x3333;
    0x3334; 0x3335; 0x3336; 0x3337; 0x3338; 0x3339; 0x333A; 0x333B; 0x333C;
    0x333D; 0x333E; 0x333F; 0x3340; 0x3341; 0x3342; 0x3343; 0x3344; 0x3345;
    0x3346; 0x3347; 0x3348; 0x3349; 0x334A; 0x334B; 0x334C; 0x334D; 0x334E;
    0x334F; 0x3350; 0x3351; 0x3352; 0x3353; 0x3354; 0x3355; 0x3356; 0x3357;
    0x3358; 0x3359; 0x335A; 0x335B; 0x335C; 0x335D; 0x335E; 0x335F; 0x3360;
    0x3361; 0x3362; 0x3363; 0x3364; 0x3365; 0x3366; 0x3367; 0x3368; 0x3369;
    0x336A; 0x336B; 0x336C; 0x336D; 0x336E; 0x336F; 0x3370; 0x3371; 0x3372;
    0x3373; 0x3374; 0x3375; 0x3376; 0x3377; 0x3378; 0x3379; 0x337A; 0x337B;
    0x337C; 0x337D; 0x337E; 0x337F; 0x3380; 0x3381; 0x3382; 0x3383; 0x3384;
    0x3385; 0x3386; 0x3387; 0x3388; 0x3389; 0x338A; 0x338B; 0x338C; 0x338D;
    0x338E; 0x338F; 0x3390; 0x3391; 0x3392; 0x3393; 0x3394; 0x3395; 0x3396;
    0x3397; 0x3398; 0x3399; 0x339A; 0x339B; 0x339C; 0x339D; 0x339E; 0x339F;
    0x33A0; 0x33A1; 0x33A2; 0x33A3; 0x33A4; 0x33A5; 0x33A6; 0x33A7; 0x33A8;
    0x33A9; 0x33AA; 0x33AB; 0x33AC; 0x33AD; 0x33AE; 0x33AF; 0x33B0; 0x33B1;
    0x33B2; 0x33B3; 0x33B4; 0x33B5; 0x33B6; 0x33B7; 0x33B8; 0x33B9; 0x33BA;
    0x33BB; 0x33BC; 0x33BD; 0x33BE; 0x33BF; 0x33C0; 0x33C1; 0x33C2; 0x33C3;
    0x33C4; 0x33C5; 0x33C6; 0x33C7; 0x33C8; 0x33C9; 0x33CA; 0x33CB; 0x33CC;
    0x33CD; 0x33CE; 0x33CF; 0x33D0; 0x33D1; 0x33D2; 0x33D3; 0x33D4; 0x33D5;
    0x33D6; 0x33D7; 0x33D8; 0x33D9; 0x33DA; 0x33DB; 0x33DC; 0x33DD; 0x33DE;
    0x33DF; 0x33E0; 0x33E1; 0x33E2; 0x33E3; 0x33E4; 0x33E5; 0x33E6; 0x33E7;
    0x33E8; 0x33E9; 0x33EA; 0x33EB; 0x33EC; 0x33ED; 0x33EE; 0x33EF; 0x33F0;
    0x33F1; 0x33F2; 0x33F3; 0x33F4; 0x33F5; 0x33F6; 0x33F7; 0x33F8; 0x33F9;
    0x33FA; 0x33FB; 0x33FC; 0x33FD; 0x33FE; 0x33FF; 0x4DC0; 0x4DC1; 0x4DC2;
    0x4DC3; 0x4DC4; 0x4DC5; 0x4DC6; 0x4DC7; 0x4DC8; 0x4DC9; 0x4DCA; 0x4DCB;
    0x4DCC; 0x4DCD; 0x4DCE; 0x4DCF; 0x4DD0; 0x4DD1; 0x4DD2; 0x4DD3; 0x4DD4;
    0x4DD5; 0x4DD6; 0x4DD7; 0x4DD8; 0x4DD9; 0x4DDA; 0x4DDB; 0x4DDC; 0x4DDD;
    0x4DDE; 0x4DDF; 0x4DE0; 0x4DE1; 0x4DE2; 0x4DE3; 0x4DE4; 0x4DE5; 0x4DE6;
    0x4DE7; 0x4DE8; 0x4DE9; 0x4DEA; 0x4DEB; 0x4DEC; 0x4DED; 0x4DEE; 0x4DEF;
    0x4DF0; 0x4DF1; 0x4DF2; 0x4DF3; 0x4DF4; 0x4DF5; 0x4DF6; 0x4DF7; 0x4DF8;
    0x4DF9; 0x4DFA; 0x4DFB; 0x4DFC; 0x4DFD; 0x4DFE; 0x4DFF; 0xA490; 0xA491;
    0xA492; 0xA493; 0xA494; 0xA495; 0xA496; 0xA497; 0xA498; 0xA499; 0xA49A;
    0xA49B; 0xA49C; 0xA49D; 0xA49E; 0xA49F; 0xA4A0; 0xA4A1; 0xA4A2; 0xA4A3;
    0xA4A4; 0xA4A5; 0xA4A6; 0xA4A7; 0xA4A8; 0xA4A9; 0xA4AA; 0xA4AB; 0xA4AC;
    0xA4AD; 0xA4AE; 0xA4AF; 0xA4B0; 0xA4B1; 0xA4B2; 0xA4B3; 0xA4B4; 0xA4B5;
    0xA4B6; 0xA4B7; 0xA4B8; 0xA4B9; 0xA4BA; 0xA4BB; 0xA4BC; 0xA4BD; 0xA4BE;
    0xA4BF; 0xA4C0; 0xA4C1; 0xA4C2; 0xA4C3; 0xA4C4; 0xA4C5; 0xA4C6; 0xA4FE;
    0xA4FF; 0xA60D; 0xA60E; 0xA60F; 0xA673; 0xA67E; 0xA6F2; 0xA6F3; 0xA6F4;
    0xA6F5; 0xA6F6; 0xA6F7; 0xA700; 0xA701; 0xA702; 0xA703; 0xA704; 0xA705;
    0xA706; 0xA707; 0xA708; 0xA709; 0xA70A; 0xA70B; 0xA70C; 0xA70D; 0xA70E;
    0xA70F; 0xA710; 0xA711; 0xA712; 0xA713; 0xA714; 0xA715; 0xA716; 0xA720;
    0xA721; 0xA789; 0xA78A; 0xA828; 0xA829; 0xA82A; 0xA82B; 0xA836; 0xA837;
    0xA838; 0xA839; 0xA874; 0xA875; 0xA876; 0xA877; 0xA8CE; 0xA8CF; 0xA8F8;
    0xA8F9; 0xA8FA; 0xA8FC; 0xA92E; 0xA92F; 0xA95F; 0xA9C1; 0xA9C2; 0xA9C3;
    0xA9C4; 0xA9C5; 0xA9C6; 0xA9C7; 0xA9C8; 0xA9C9; 0xA9CA; 0xA9CB; 0xA9CC;
    0xA9CD; 0xA9DE; 0xA9DF; 0xAA5C; 0xAA5D; 0xAA5E; 0xAA5F; 0xAA77; 0xAA78;
    0xAA79; 0xAADE; 0xAADF; 0xAAF0; 0xAAF1; 0xAB5B; 0xAB6A; 0xAB6B; 0xABEB;
    0xFB29; 0xFBB2; 0xFBB3; 0xFBB4; 0xFBB5; 0xFBB6; 0xFBB7; 0xFBB8; 0xFBB9;
    0xFBBA; 0xFBBB; 0xFBBC; 0xFBBD; 0xFBBE; 0xFBBF; 0xFBC0; 0xFBC1; 0xFBC2;
    0xFBC3; 0xFBC4; 0xFBC5; 0xFBC6; 0xFBC7; 0xFBC8; 0xFBC9; 0xFBCA; 0xFBCB;
    0xFBCC; 0xFBCD; 0xFBCE; 0xFBCF; 0xFBD0; 0xFBD1; 0xFBD2; 0xFD3E; 0xFD3F;
    0xFD40; 0xFD41; 0xFD42; 0xFD43; 0xFD44; 0xFD45; 0xFD46; 0xFD47; 0xFD48;
    0xFD49; 0xFD4A; 0xFD4B; 0xFD4C; 0xFD4D; 0xFD4E; 0xFD4F; 0xFD90; 0xFD91;
    0xFDC8; 0xFDC9; 0xFDCA; 0xFDCB; 0xFDCC; 0xFDCD; 0xFDCE; 0xFDCF; 0xFDFC;
    0xFDFD; 0xFDFE; 0xFDFF; 0xFE10; 0xFE11; 0xFE12; 0xFE13; 0xFE14; 0xFE15;
    0xFE16; 0xFE17; 0xFE18; 0xFE19; 0xFE30; 0xFE31; 0xFE32; 0xFE33; 0xFE34;
    0xFE35; 0xFE36; 0xFE37; 0xFE38; 0xFE39; 0xFE3A; 0xFE3B; 0xFE3C; 0xFE3D;
    0xFE3E; 0xFE3F; 0xFE40; 0xFE41; 0xFE42; 0xFE43; 0xFE44; 0xFE45; 0xFE46;
    0xFE47; 0xFE48; 0xFE49; 0xFE4A; 0xFE4B; 0xFE4C; 0xFE4D; 0xFE4E; 0xFE4F;
    0xFE50; 0xFE51; 0xFE52; 0xFE54; 0xFE55; 0xFE56; 0xFE57; 0xFE58; 0xFE59;
    0xFE5A; 0xFE5B; 0xFE5C; 0xFE5D; 0xFE5E; 0xFE5F; 0xFE60; 0xFE61; 0xFE62;
    0xFE63; 0xFE64; 0xFE65; 0xFE66; 0xFE68; 0xFE69; 0xFE6A; 0xFE6B; 0xFF01;
    0xFF02; 0xFF03; 0xFF04; 0xFF05; 0xFF06; 0xFF07; 0xFF08; 0xFF09; 0xFF0A;
    0xFF0B; 0xFF0C; 0xFF0D; 0xFF0E; 0xFF0F; 0xFF1A; 0xFF1B; 0xFF1C; 0xFF1D;
    0xFF1E; 0xFF1F; 0xFF20; 0xFF3B; 0xFF3C; 0xFF3D; 0xFF3E; 0xFF3F; 0xFF40;
    0xFF5B; 0xFF5C; 0xFF5D; 0xFF5E; 0xFF5F; 0xFF60; 0xFF61; 0xFF62; 0xFF63;
    0xFF64; 0xFF65; 0xFFE0; 0xFFE1; 0xFFE2; 0xFFE3; 0xFFE4; 0xFFE5; 0xFFE6;
    0xFFE8; 0xFFE9; 0xFFEA; 0xFFEB; 0xFFEC; 0xFFED; 0xFFEE; 0xFFFC; 0xFFFD;
    0x10100; 0x10101; 0x10102; 0x10137; 0x10138; 0x10139; 0x1013A; 0x1013B;
    0x1013C; 0x1013D; 0x1013E; 0x1013F; 0x10179; 0x1017A; 0x1017B; 0x1017C;
    0x1017D; 0x1017E; 0x1017F; 0x10180; 0x10181; 0x10182; 0x10183; 0x10184;
    0x10185; 0x10186; 0x10187; 0x10188; 0x10189; 0x1018C; 0x1018D; 0x1018E;
    0x10190; 0x10191; 0x10192; 0x10193; 0x10194; 0x10195; 0x10196; 0x10197;
    0x10198; 0x10199; 0x1019A; 0x1019B; 0x1019C; 0x101A0; 0x101D0; 0x101D1;
    0x101D2; 0x101D3; 0x101D4; 0x101D5; 0x101D6; 0x101D7; 0x101D8; 0x101D9;
    0x101DA; 0x101DB; 0x101DC; 0x101DD; 0x101DE; 0x101DF; 0x101E0; 0x101E1;
    0x101E2; 0x101E3; 0x101E4; 0x101E5; 0x101E6; 0x101E7; 0x101E8; 0x101E9;
    0x101EA; 0x101EB; 0x101EC; 0x101ED; 0x101EE; 0x101EF; 0x101F0; 0x101F1;
    0x101F2; 0x101F3; 0x101F4; 0x101F5; 0x101F6; 0x101F7; 0x101F8; 0x101F9;
    0x101FA; 0x101FB; 0x101FC; 0x1039F; 0x103D0; 0x1056F; 0x10857; 0x10877;
    0x10878; 0x1091F; 0x1093F; 0x10A50; 0x10A51; 0x10A52; 0x10A53; 0x10A54;
    0x10A55; 0x10A56; 0x10A57; 0x10A58; 0x10A7F; 0x10AC8; 0x10AF0; 0x10AF1;
    0x10AF2; 0x10AF3; 0x10AF4; 0x10AF5; 0x10AF6; 0x10B39; 0x10B3A; 0x10B3B;
    0x10B3C; 0x10B3D; 0x10B3E; 0x10B3F; 0x10B99; 0x10B9A; 0x10B9B; 0x10B9C;
    0x10D6E; 0x10D8E; 0x10D8F; 0x10EAD; 0x10ED0; 0x10ED1; 0x10ED2; 0x10ED3;
    0x10ED4; 0x10ED5; 0x10ED6; 0x10ED7; 0x10ED8; 0x10F55; 0x10F56; 0x10F57;
    0x10F58; 0x10F59; 0x10F86; 0x10F87; 0x10F88; 0x10F89; 0x11047; 0x11048;
    0x11049; 0x1104A; 0x1104B; 0x1104C; 0x1104D; 0x110BB; 0x110BC; 0x110BE;
    0x110BF; 0x110C0; 0x110C1; 0x11140; 0x11141; 0x11142; 0x11143; 0x11174;
    0x11175; 0x111C5; 0x111C6; 0x111C7; 0x111C8; 0x111CD; 0x111DB; 0x111DD;
    0x111DE; 0x111DF; 0x11238; 0x11239; 0x1123A; 0x1123B; 0x1123C; 0x1123D;
    0x112A9; 0x113D4; 0x113D5; 0x113D7; 0x113D8; 0x1144B; 0x1144C; 0x1144D;
    0x1144E; 0x1144F; 0x1145A; 0x1145B; 0x1145D; 0x114C6; 0x115C1; 0x115C2;
    0x115C3; 0x115C4; 0x115C5; 0x115C6; 0x115C7; 0x115C8; 0x115C9; 0x115CA;
    0x115CB; 0x115CC; 0x115CD; 0x115CE; 0x115CF; 0x115D0; 0x115D1; 0x115D2;
    0x115D3; 0x115D4; 0x115D5; 0x115D6; 0x115D7; 0x11641; 0x11642; 0x11643;
    0x11660; 0x11661; 0x11662; 0x11663; 0x11664; 0x11665; 0x11666; 0x11667;
    0x11668; 0x11669; 0x1166A; 0x1166B; 0x1166C; 0x116B9; 0x1173C; 0x1173D;
    0x1173E; 0x1173F; 0x1183B; 0x11944; 0x11945; 0x11946; 0x119E2; 0x11A3F;
    0x11A40; 0x11A41; 0x11A42; 0x11A43; 0x11A44; 0x11A45; 0x11A46; 0x11A9A;
    0x11A9B; 0x11A9C; 0x11A9E; 0x11A9F; 0x11AA0; 0x11AA1; 0x11AA2; 0x11B00;
    0x11B01; 0x11B02; 0x11B03; 0x11B04; 0x11B05; 0x11B06; 0x11B07; 0x11B08;
    0x11B09; 0x11BE1; 0x11C41; 0x11C42; 0x11C43; 0x11C44; 0x11C45; 0x11C70;
    0x11C71; 0x11EF7; 0x11EF8; 0x11F43; 0x11F44; 0x11F45; 0x11F46; 0x11F47;
    0x11F48; 0x11F49; 0x11F4A; 0x11F4B; 0x11F4C; 0x11F4D; 0x11F4E; 0x11F4F;
    0x11FD5; 0x11FD6; 0x11FD7; 0x11FD8; 0x11FD9; 0x11FDA; 0x11FDB; 0x11FDC;
    0x11FDD; 0x11FDE; 0x11FDF; 0x11FE0; 0x11FE1; 0x11FE2; 0x11FE3; 0x11FE4;
    0x11FE5; 0x11FE6; 0x11FE7; 0x11FE8; 0x11FE9; 0x11FEA; 0x11FEB; 0x11FEC;
    0x11FED; 0x11FEE; 0x11FEF; 0x11FF0; 0x11FF1; 0x11FFF; 0x12470; 0x12471;
    0x12472; 0x12473; 0x12474; 0x12FF1; 0x12FF2; 0x16A6E; 0x16A6F; 0x16AF5;
    0x16B37; 0x16B38; 0x16B39; 0x16B3A; 0x16B3B; 0x16B3C; 0x16B3D; 0x16B3E;
    0x16B3F; 0x16B44; 0x16B45; 0x16D6D; 0x16D6E; 0x16D6F; 0x16E97; 0x16E98;
    0x16E99; 0x16E9A; 0x16FE2; 0x1BC9C; 0x1BC9F; 0x1CC00; 0x1CC01; 0x1CC02;
    0x1CC03; 0x1CC04; 0x1CC05; 0x1CC06; 0x1CC07; 0x1CC08; 0x1CC09; 0x1CC0A;
    0x1CC0B; 0x1CC0C; 0x1CC0D; 0x1CC0E; 0x1CC0F; 0x1CC10; 0x1CC11; 0x1CC12;
    0x1CC13; 0x1CC14; 0x1CC15; 0x1CC16; 0x1CC17; 0x1CC18; 0x1CC19; 0x1CC1A;
    0x1CC1B; 0x1CC1C; 0x1CC1D; 0x1CC1E; 0x1CC1F; 0x1CC20; 0x1CC21; 0x1CC22;
    0x1CC23; 0x1CC24; 0x1CC25; 0x1CC26; 0x1CC27; 0x1CC28; 0x1CC29; 0x1CC2A;
    0x1CC2B; 0x1CC2C; 0x1CC2D; 0x1CC2E; 0x1CC2F; 0x1CC30; 0x1CC31; 0x1CC32;
    0x1CC33; 0x1CC34; 0x1CC35; 0x1CC36; 0x1CC37; 0x1CC38; 0x1CC39; 0x1CC3A;
    0x1CC3B; 0x1CC3C; 0x1CC3D; 0x1CC3E; 0x1CC3F; 0x1CC40; 0x1CC41; 0x1CC42;
    0x1CC43; 0x1CC44; 0x1CC45; 0x1CC46; 0x1CC47; 0x1CC48; 0x1CC49; 0x1CC4A;
    0x1CC4B; 0x1CC4C; 0x1CC4D; 0x1CC4E; 0x1CC4F; 0x1CC50; 0x1CC51; 0x1CC52;
    0x1CC53; 0x1CC54; 0x1CC55; 0x1CC56; 0x1CC57; 0x1CC58; 0x1CC59; 0x1CC5A;
    0x1CC5B; 0x1CC5C; 0x1CC5D; 0x1CC5E; 0x1CC5F; 0x1CC60; 0x1CC61; 0x1CC62;
    0x1CC63; 0x1CC64; 0x1CC65; 0x1CC66; 0x1CC67; 0x1CC68; 0x1CC69; 0x1CC6A;
    0x1CC6B; 0x1CC6C; 0x1CC6D; 0x1CC6E; 0x1CC6F; 0x1CC70; 0x1CC71; 0x1CC72;
    0x1CC73; 0x1CC74; 0x1CC75; 0x1CC76; 0x1CC77; 0x1CC78; 0x1CC79; 0x1CC7A;
    0x1CC7B; 0x1CC7C; 0x1CC7D; 0x1CC7E; 0x1CC7F; 0x1CC80; 0x1CC81; 0x1CC82;
    0x1CC83; 0x1CC84; 0x1CC85; 0x1CC86; 0x1CC87; 0x1CC88; 0x1CC89; 0x1CC8A;
    0x1CC8B; 0x1CC8C; 0x1CC8D; 0x1CC8E; 0x1CC8F; 0x1CC90; 0x1CC91; 0x1CC92;
    0x1CC93; 0x1CC94; 0x1CC95; 0x1CC96; 0x1CC97; 0x1CC98; 0x1CC99; 0x1CC9A;
    0x1CC9B; 0x1CC9C; 0x1CC9D; 0x1CC9E; 0x1CC9F; 0x1CCA0; 0x1CCA1; 0x1CCA2;
    0x1CCA3; 0x1CCA4; 0x1CCA5; 0x1CCA6; 0x1CCA7; 0x1CCA8; 0x1CCA9; 0x1CCAA;
    0x1CCAB; 0x1CCAC; 0x1CCAD; 0x1CCAE; 0x1CCAF; 0x1CCB0; 0x1CCB1; 0x1CCB2;
    0x1CCB3; 0x1CCB4; 0x1CCB5; 0x1CCB6; 0x1CCB7; 0x1CCB8; 0x1CCB9; 0x1CCBA;
    0x1CCBB; 0x1CCBC; 0x1CCBD; 0x1CCBE; 0x1CCBF; 0x1CCC0; 0x1CCC1; 0x1CCC2;
    0x1CCC3; 0x1CCC4; 0x1CCC5; 0x1CCC6; 0x1CCC7; 0x1CCC8; 0x1CCC9; 0x1CCCA;
    0x1CCCB; 0x1CCCC; 0x1CCCD; 0x1CCCE; 0x1CCCF; 0x1CCD0; 0x1CCD1; 0x1CCD2;
    0x1CCD3; 0x1CCD4; 0x1CCD5; 0x1CCD6; 0x1CCD7; 0x1CCD8; 0x1CCD9; 0x1CCDA;
    0x1CCDB; 0x1CCDC; 0x1CCDD; 0x1CCDE; 0x1CCDF; 0x1CCE0; 0x1CCE1; 0x1CCE2;
    0x1CCE3; 0x1CCE4; 0x1CCE5; 0x1CCE6; 0x1CCE7; 0x1CCE8; 0x1CCE9; 0x1CCEA;
    0x1CCEB; 0x1CCEC; 0x1CCED; 0x1CCEE; 0x1CCEF; 0x1CCFA; 0x1CCFB; 0x1CCFC;
    0x1CD00; 0x1CD01; 0x1CD02; 0x1CD03; 0x1CD04; 0x1CD05; 0x1CD06; 0x1CD07;
    0x1CD08; 0x1CD09; 0x1CD0A; 0x1CD0B; 0x1CD0C; 0x1CD0D; 0x1CD0E; 0x1CD0F;
    0x1CD10; 0x1CD11; 0x1CD12; 0x1CD13; 0x1CD14; 0x1CD15; 0x1CD16; 0x1CD17;
    0x1CD18; 0x1CD19; 0x1CD1A; 0x1CD1B; 0x1CD1C; 0x1CD1D; 0x1CD1E; 0x1CD1F;
    0x1CD20; 0x1CD21; 0x1CD22; 0x1CD23; 0x1CD24; 0x1CD25; 0x1CD26; 0x1CD27;
    0x1CD28; 0x1CD29; 0x1CD2A; 0x1CD2B; 0x1CD2C; 0x1CD2D; 0x1CD2E; 0x1CD2F;
    0x1CD30; 0x1CD31; 0x1CD32; 0x1CD33; 0x1CD34; 0x1CD35; 0x1CD36; 0x1CD37;
    0x1CD38; 0x1CD39; 0x1CD3A; 0x1CD3B; 0x1CD3C; 0x1CD3D; 0x1CD3E; 0x1CD3F;
    0x1CD40; 0x1CD41; 0x1CD42; 0x1CD43; 0x1CD44; 0x1CD45; 0x1CD46; 0x1CD47;
    0x1CD48; 0x1CD49; 0x1CD4A; 0x1CD4B; 0x1CD4C; 0x1CD4D; 0x1CD4E; 0x1CD4F;
    0x1CD50; 0x1CD51; 0x1CD52; 0x1CD53; 0x1CD54; 0x1CD55; 0x1CD56; 0x1CD57;
    0x1CD58; 0x1CD59; 0x1CD5A; 0x1CD5B; 0x1CD5C; 0x1CD5D; 0x1CD5E; 0x1CD5F;
    0x1CD60; 0x1CD61; 0x1CD62; 0x1CD63; 0x1CD64; 0x1CD65; 0x1CD66; 0x1CD67;
    0x1CD68; 0x1CD69; 0x1CD6A; 0x1CD6B; 0x1CD6C; 0x1CD6D; 0x1CD6E; 0x1CD6F;
    0x1CD70; 0x1CD71; 0x1CD72; 0x1CD73; 0x1CD74; 0x1CD75; 0x1CD76; 0x1CD77;
    0x1CD78; 0x1CD79; 0x1CD7A; 0x1CD7B; 0x1CD7C; 0x1CD7D; 0x1CD7E; 0x1CD7F;
    0x1CD80; 0x1CD81; 0x1CD82; 0x1CD83; 0x1CD84; 0x1CD85; 0x1CD86; 0x1CD87;
    0x1CD88; 0x1CD89; 0x1CD8A; 0x1CD8B; 0x1CD8C; 0x1CD8D; 0x1CD8E; 0x1CD8F;
    0x1CD90; 0x1CD91; 0x1CD92; 0x1CD93; 0x1CD94; 0x1CD95; 0x1CD96; 0x1CD97;
    0x1CD98; 0x1CD99; 0x1CD9A; 0x1CD9B; 0x1CD9C; 0x1CD9D; 0x1CD9E; 0x1CD9F;
    0x1CDA0; 0x1CDA1; 0x1CDA2; 0x1CDA3; 0x1CDA4; 0x1CDA5; 0x1CDA6; 0x1CDA7;
    0x1CDA8; 0x1CDA9; 0x1CDAA; 0x1CDAB; 0x1CDAC; 0x1CDAD; 0x1CDAE; 0x1CDAF;
    0x1CDB0; 0x1CDB1; 0x1CDB2; 0x1CDB3; 0x1CDB4; 0x1CDB5; 0x1CDB6; 0x1CDB7;
    0x1CDB8; 0x1CDB9; 0x1CDBA; 0x1CDBB; 0x1CDBC; 0x1CDBD; 0x1CDBE; 0x1CDBF;
    0x1CDC0; 0x1CDC1; 0x1CDC2; 0x1CDC3; 0x1CDC4; 0x1CDC5; 0x1CDC6; 0x1CDC7;
    0x1CDC8; 0x1CDC9; 0x1CDCA; 0x1CDCB; 0x1CDCC; 0x1CDCD; 0x1CDCE; 0x1CDCF;
    0x1CDD0; 0x1CDD1; 0x1CDD2; 0x1CDD3; 0x1CDD4; 0x1CDD5; 0x1CDD6; 0x1CDD7;
    0x1CDD8; 0x1CDD9; 0x1CDDA; 0x1CDDB; 0x1CDDC; 0x1CDDD; 0x1CDDE; 0x1CDDF;
    0x1CDE0; 0x1CDE1; 0x1CDE2; 0x1CDE3; 0x1CDE4; 0x1CDE5; 0x1CDE6; 0x1CDE7;
    0x1CDE8; 0x1CDE9; 0x1CDEA; 0x1CDEB; 0x1CDEC; 0x1CDED; 0x1CDEE; 0x1CDEF;
    0x1CDF0; 0x1CDF1; 0x1CDF2; 0x1CDF3; 0x1CDF4; 0x1CDF5; 0x1CDF6; 0x1CDF7;
    0x1CDF8; 0x1CDF9; 0x1CDFA; 0x1CDFB; 0x1CDFC; 0x1CDFD; 0x1CDFE; 0x1CDFF;
    0x1CE00; 0x1CE01; 0x1CE02; 0x1CE03; 0x1CE04; 0x1CE05; 0x1CE06; 0x1CE07;
    0x1CE08; 0x1CE09; 0x1CE0A; 0x1CE0B; 0x1CE0C; 0x1CE0D; 0x1CE0E; 0x1CE0F;
    0x1CE10; 0x1CE11; 0x1CE12; 0x1CE13; 0x1CE14; 0x1CE15; 0x1CE16; 0x1CE17;
    0x1CE18; 0x1CE19; 0x1CE1A; 0x1CE1B; 0x1CE1C; 0x1CE1D; 0x1CE1E; 0x1CE1F;
    0x1CE20; 0x1CE21; 0x1CE22; 0x1CE23; 0x1CE24; 0x1CE25; 0x1CE26; 0x1CE27;
    0x1CE28; 0x1CE29; 0x1CE2A; 0x1CE2B; 0x1CE2C; 0x1CE2D; 0x1CE2E; 0x1CE2F;
    0x1CE30; 0x1CE31; 0x1CE32; 0x1CE33; 0x1CE34; 0x1CE35; 0x1CE36; 0x1CE37;
    0x1CE38; 0x1CE39; 0x1CE3A; 0x1CE3B; 0x1CE3C; 0x1CE3D; 0x1CE3E; 0x1CE3F;
    0x1CE40; 0x1CE41; 0x1CE42; 0x1CE43; 0x1CE44; 0x1CE45; 0x1CE46; 0x1CE47;
    0x1CE48; 0x1CE49; 0x1CE4A; 0x1CE4B; 0x1CE4C; 0x1CE4D; 0x1CE4E; 0x1CE4F;
    0x1CE50; 0x1CE51; 0x1CE52; 0x1CE53; 0x1CE54; 0x1CE55; 0x1CE56; 0x1CE57;
    0x1CE58; 0x1CE59; 0x1CE5A; 0x1CE5B; 0x1CE5C; 0x1CE5D; 0x1CE5E; 0x1CE5F;
    0x1CE60; 0x1CE61; 0x1CE62; 0x1CE63; 0x1CE64; 0x1CE65; 0x1CE66; 0x1CE67;
    0x1CE68; 0x1CE69; 0x1CE6A; 0x1CE6B; 0x1CE6C; 0x1CE6D; 0x1CE6E; 0x1CE6F;
    0x1CE70; 0x1CE71; 0x1CE72; 0x1CE73; 0x1CE74; 0x1CE75; 0x1CE76; 0x1CE77;
    0x1CE78; 0x1CE79; 0x1CE7A; 0x1CE7B; 0x1CE7C; 0x1CE7D; 0x1CE7E; 0x1CE7F;
    0x1CE80; 0x1CE81; 0x1CE82; 0x1CE83; 0x1CE84; 0x1CE85; 0x1CE86; 0x1CE87;
    0x1CE88; 0x1CE89; 0x1CE8A; 0x1CE8B; 0x1CE8C; 0x1CE8D; 0x1CE8E; 0x1CE8F;
    0x1CE90; 0x1CE91; 0x1CE92; 0x1CE93; 0x1CE94; 0x1CE95; 0x1CE96; 0x1CE97;
    0x1CE98; 0x1CE99; 0x1CE9A; 0x1CE9B; 0x1CE9C; 0x1CE9D; 0x1CE9E; 0x1CE9F;
    0x1CEA0; 0x1CEA1; 0x1CEA2; 0x1CEA3; 0x1CEA4; 0x1CEA5; 0x1CEA6; 0x1CEA7;
    0x1CEA8; 0x1CEA9; 0x1CEAA; 0x1CEAB; 0x1CEAC; 0x1CEAD; 0x1CEAE; 0x1CEAF;
    0x1CEB0; 0x1CEB1; 0x1CEB2; 0x1CEB3; 0x1CEBA; 0x1CEBB; 0x1CEBC; 0x1CEBD;
    0x1CEBE; 0x1CEBF; 0x1CEC0; 0x1CEC1; 0x1CEC2; 0x1CEC3; 0x1CEC4; 0x1CEC5;
    0x1CEC6; 0x1CEC7; 0x1CEC8; 0x1CEC9; 0x1CECA; 0x1CECB; 0x1CECC; 0x1CECD;
    0x1CECE; 0x1CECF; 0x1CED0; 0x1CEE0; 0x1CEE1; 0x1CEE2; 0x1CEE3; 0x1CEE4;
    0x1CEE5; 0x1CEE6; 0x1CEE7; 0x1CEE8; 0x1CEE9; 0x1CEEA; 0x1CEEB; 0x1CEEC;
    0x1CEED; 0x1CEEE; 0x1CEEF; 0x1CEF0; 0x1CF50; 0x1CF51; 0x1CF52; 0x1CF53;
    0x1CF54; 0x1CF55; 0x1CF56; 0x1CF57; 0x1CF58; 0x1CF59; 0x1CF5A; 0x1CF5B;
    0x1CF5C; 0x1CF5D; 0x1CF5E; 0x1CF5F; 0x1CF60; 0x1CF61; 0x1CF62; 0x1CF63;
    0x1CF64; 0x1CF65; 0x1CF66; 0x1CF67; 0x1CF68; 0x1CF69; 0x1CF6A; 0x1CF6B;
    0x1CF6C; 0x1CF6D; 0x1CF6E; 0x1CF6F; 0x1CF70; 0x1CF71; 0x1CF72; 0x1CF73;
    0x1CF74; 0x1CF75; 0x1CF76; 0x1CF77; 0x1CF78; 0x1CF79; 0x1CF7A; 0x1CF7B;
    0x1CF7C; 0x1CF7D; 0x1CF7E; 0x1CF7F; 0x1CF80; 0x1CF81; 0x1CF82; 0x1CF83;
    0x1CF84; 0x1CF85; 0x1CF86; 0x1CF87; 0x1CF88; 0x1CF89; 0x1CF8A; 0x1CF8B;
    0x1CF8C; 0x1CF8D; 0x1CF8E; 0x1CF8F; 0x1CF90; 0x1CF91; 0x1CF92; 0x1CF93;
    0x1CF94; 0x1CF95; 0x1CF96; 0x1CF97; 0x1CF98; 0x1CF99; 0x1CF9A; 0x1CF9B;
    0x1CF9C; 0x1CF9D; 0x1CF9E; 0x1CF9F; 0x1CFA0; 0x1CFA1; 0x1CFA2; 0x1CFA3;
    0x1CFA4; 0x1CFA5; 0x1CFA6; 0x1CFA7; 0x1CFA8; 0x1CFA9; 0x1CFAA; 0x1CFAB;
    0x1CFAC; 0x1CFAD; 0x1CFAE; 0x1CFAF; 0x1CFB0; 0x1CFB1; 0x1CFB2; 0x1CFB3;
    0x1CFB4; 0x1CFB5; 0x1CFB6; 0x1CFB7; 0x1CFB8; 0x1CFB9; 0x1CFBA; 0x1CFBB;
    0x1CFBC; 0x1CFBD; 0x1CFBE; 0x1CFBF; 0x1CFC0; 0x1CFC1; 0x1CFC2; 0x1CFC3;
    0x1D000; 0x1D001; 0x1D002; 0x1D003; 0x1D004; 0x1D005; 0x1D006; 0x1D007;
    0x1D008; 0x1D009; 0x1D00A; 0x1D00B; 0x1D00C; 0x1D00D; 0x1D00E; 0x1D00F;
    0x1D010; 0x1D011; 0x1D012; 0x1D013; 0x1D014; 0x1D015; 0x1D016; 0x1D017;
    0x1D018; 0x1D019; 0x1D01A; 0x1D01B; 0x1D01C; 0x1D01D; 0x1D01E; 0x1D01F;
    0x1D020; 0x1D021; 0x1D022; 0x1D023; 0x1D024; 0x1D025; 0x1D026; 0x1D027;
    0x1D028; 0x1D029; 0x1D02A; 0x1D02B; 0x1D02C; 0x1D02D; 0x1D02E; 0x1D02F;
    0x1D030; 0x1D031; 0x1D032; 0x1D033; 0x1D034; 0x1D035; 0x1D036; 0x1D037;
    0x1D038; 0x1D039; 0x1D03A; 0x1D03B; 0x1D03C; 0x1D03D; 0x1D03E; 0x1D03F;
    0x1D040; 0x1D041; 0x1D042; 0x1D043; 0x1D044; 0x1D045; 0x1D046; 0x1D047;
    0x1D048; 0x1D049; 0x1D04A; 0x1D04B; 0x1D04C; 0x1D04D; 0x1D04E; 0x1D04F;
    0x1D050; 0x1D051; 0x1D052; 0x1D053; 0x1D054; 0x1D055; 0x1D056; 0x1D057;
    0x1D058; 0x1D059; 0x1D05A; 0x1D05B; 0x1D05C; 0x1D05D; 0x1D05E; 0x1D05F;
    0x1D060; 0x1D061; 0x1D062; 0x1D063; 0x1D064; 0x1D065; 0x1D066; 0x1D067;
    0x1D068; 0x1D069; 0x1D06A; 0x1D06B; 0x1D06C; 0x1D06D; 0x1D06E; 0x1D06F;
    0x1D070; 0x1D071; 0x1D072; 0x1D073; 0x1D074; 0x1D075; 0x1D076; 0x1D077;
    0x1D078; 0x1D079; 0x1D07A; 0x1D07B; 0x1D07C; 0x1D07D; 0x1D07E; 0x1D07F;
    0x1D080; 0x1D081; 0x1D082; 0x1D083; 0x1D084; 0x1D085; 0x1D086; 0x1D087;
    0x1D088; 0x1D089; 0x1D08A; 0x1D08B; 0x1D08C; 0x1D08D; 0x1D08E; 0x1D08F;
    0x1D090; 0x1D091; 0x1D092; 0x1D093; 0x1D094; 0x1D095; 0x1D096; 0x1D097;
    0x1D098; 0x1D099; 0x1D09A; 0x1D09B; 0x1D09C; 0x1D09D; 0x1D09E; 0x1D09F;
    0x1D0A0; 0x1D0A1; 0x1D0A2; 0x1D0A3; 0x1D0A4; 0x1D0A5; 0x1D0A6; 0x1D0A7;
    0x1D0A8; 0x1D0A9; 0x1D0AA; 0x1D0AB; 0x1D0AC; 0x1D0AD; 0x1D0AE; 0x1D0AF;
    0x1D0B0; 0x1D0B1; 0x1D0B2; 0x1D0B3; 0x1D0B4; 0x1D0B5; 0x1D0B6; 0x1D0B7;
    0x1D0B8; 0x1D0B9; 0x1D0BA; 0x1D0BB; 0x1D0BC; 0x1D0BD; 0x1D0BE; 0x1D0BF;
    0x1D0C0; 0x1D0C1; 0x1D0C2; 0x1D0C3; 0x1D0C4; 0x1D0C5; 0x1D0C6; 0x1D0C7;
    0x1D0C8; 0x1D0C9; 0x1D0CA; 0x1D0CB; 0x1D0CC; 0x1D0CD; 0x1D0CE; 0x1D0CF;
    0x1D0D0; 0x1D0D1; 0x1D0D2; 0x1D0D3; 0x1D0D4; 0x1D0D5; 0x1D0D6; 0x1D0D7;
    0x1D0D8; 0x1D0D9; 0x1D0DA; 0x1D0DB; 0x1D0DC; 0x1D0DD; 0x1D0DE; 0x1D0DF;
    0x1D0E0; 0x1D0E1; 0x1D0E2; 0x1D0E3; 0x1D0E4; 0x1D0E5; 0x1D0E6; 0x1D0E7;
    0x1D0E8; 0x1D0E9; 0x1D0EA; 0x1D0EB; 0x1D0EC; 0x1D0ED; 0x1D0EE; 0x1D0EF;
    0x1D0F0; 0x1D0F1; 0x1D0F2; 0x1D0F3; 0x1D0F4; 0x1D0F5; 0x1D100; 0x1D101;
    0x1D102; 0x1D103; 0x1D104; 0x1D105; 0x1D106; 0x1D107; 0x1D108; 0x1D109;
    0x1D10A; 0x1D10B; 0x1D10C; 0x1D10D; 0x1D10E; 0x1D10F; 0x1D110; 0x1D111;
    0x1D112; 0x1D113; 0x1D114; 0x1D115; 0x1D116; 0x1D117; 0x1D118; 0x1D119;
    0x1D11A; 0x1D11B; 0x1D11C; 0x1D11D; 0x1D11E; 0x1D11F; 0x1D120; 0x1D121;
    0x1D122; 0x1D123; 0x1D124; 0x1D125; 0x1D126; 0x1D129; 0x1D12A; 0x1D12B;
    0x1D12C; 0x1D12D; 0x1D12E; 0x1D12F; 0x1D130; 0x1D131; 0x1D132; 0x1D133;
    0x1D134; 0x1D135; 0x1D136; 0x1D137; 0x1D138; 0x1D139; 0x1D13A; 0x1D13B;
    0x1D13C; 0x1D13D; 0x1D13E; 0x1D13F; 0x1D140; 0x1D141; 0x1D142; 0x1D143;
    0x1D144; 0x1D145; 0x1D146; 0x1D147; 0x1D148; 0x1D149; 0x1D14A; 0x1D14B;
    0x1D14C; 0x1D14D; 0x1D14E; 0x1D14F; 0x1D150; 0x1D151; 0x1D152; 0x1D153;
    0x1D154; 0x1D155; 0x1D156; 0x1D157; 0x1D158; 0x1D159; 0x1D15A; 0x1D15B;
    0x1D15C; 0x1D15D; 0x1D15E; 0x1D15F; 0x1D160; 0x1D161; 0x1D162; 0x1D163;
    0x1D164; 0x1D16A; 0x1D16B; 0x1D16C; 0x1D183; 0x1D184; 0x1D18C; 0x1D18D;
    0x1D18E; 0x1D18F; 0x1D190; 0x1D191; 0x1D192; 0x1D193; 0x1D194; 0x1D195;
    0x1D196; 0x1D197; 0x1D198; 0x1D199; 0x1D19A; 0x1D19B; 0x1D19C; 0x1D19D;
    0x1D19E; 0x1D19F; 0x1D1A0; 0x1D1A1; 0x1D1A2; 0x1D1A3; 0x1D1A4; 0x1D1A5;
    0x1D1A6; 0x1D1A7; 0x1D1A8; 0x1D1A9; 0x1D1AE; 0x1D1AF; 0x1D1B0; 0x1D1B1;
    0x1D1B2; 0x1D1B3; 0x1D1B4; 0x1D1B5; 0x1D1B6; 0x1D1B7; 0x1D1B8; 0x1D1B9;
    0x1D1BA; 0x1D1BB; 0x1D1BC; 0x1D1BD; 0x1D1BE; 0x1D1BF; 0x1D1C0; 0x1D1C1;
    0x1D1C2; 0x1D1C3; 0x1D1C4; 0x1D1C5; 0x1D1C6; 0x1D1C7; 0x1D1C8; 0x1D1C9;
    0x1D1CA; 0x1D1CB; 0x1D1CC; 0x1D1CD; 0x1D1CE; 0x1D1CF; 0x1D1D0; 0x1D1D1;
    0x1D1D2; 0x1D1D3; 0x1D1D4; 0x1D1D5; 0x1D1D6; 0x1D1D7; 0x1D1D8; 0x1D1D9;
    0x1D1DA; 0x1D1DB; 0x1D1DC; 0x1D1DD; 0x1D1DE; 0x1D1DF; 0x1D1E0; 0x1D1E1;
    0x1D1E2; 0x1D1E3; 0x1D1E4; 0x1D1E5; 0x1D1E6; 0x1D1E7; 0x1D1E8; 0x1D1E9;
    0x1D1EA; 0x1D200; 0x1D201; 0x1D202; 0x1D203; 0x1D204; 0x1D205; 0x1D206;
    0x1D207; 0x1D208; 0x1D209; 0x1D20A; 0x1D20B; 0x1D20C; 0x1D20D; 0x1D20E;
    0x1D20F; 0x1D210; 0x1D211; 0x1D212; 0x1D213; 0x1D214; 0x1D215; 0x1D216;
    0x1D217; 0x1D218; 0x1D219; 0x1D21A; 0x1D21B; 0x1D21C; 0x1D21D; 0x1D21E;
    0x1D21F; 0x1D220; 0x1D221; 0x1D222; 0x1D223; 0x1D224; 0x1D225; 0x1D226;
    0x1D227; 0x1D228; 0x1D229; 0x1D22A; 0x1D22B; 0x1D22C; 0x1D22D; 0x1D22E;
    0x1D22F; 0x1D230; 0x1D231; 0x1D232; 0x1D233; 0x1D234; 0x1D235; 0x1D236;
    0x1D237; 0x1D238; 0x1D239; 0x1D23A; 0x1D23B; 0x1D23C; 0x1D23D; 0x1D23E;
    0x1D23F; 0x1D240; 0x1D241; 0x1D245; 0x1D300; 0x1D301; 0x1D302; 0x1D303;
    0x1D304; 0x1D305; 0x1D306; 0x1D307; 0x1D308; 0x1D309; 0x1D30A; 0x1D30B;
    0x1D30C; 0x1D30D; 0x1D30E; 0x1D30F; 0x1D310; 0x1D311; 0x1D312; 0x1D313;
    0x1D314; 0x1D315; 0x1D316; 0x1D317; 0x1D318; 0x1D319; 0x1D31A; 0x1D31B;
    0x1D31C; 0x1D31D; 0x1D31E; 0x1D31F; 0x1D320; 0x1D321; 0x1D322; 0x1D323;
    0x1D324; 0x1D325; 0x1D326; 0x1D327; 0x1D328; 0x1D329; 0x1D32A; 0x1D32B;
    0x1D32C; 0x1D32D; 0x1D32E; 0x1D32F; 0x1D330; 0x1D331; 0x1D332; 0x1D333;
    0x1D334; 0x1D335; 0x1D336; 0x1D337; 0x1D338; 0x1D339; 0x1D33A; 0x1D33B;
    0x1D33C; 0x1D33D; 0x1D33E; 0x1D33F; 0x1D340; 0x1D341; 0x1D342; 0x1D343;
    0x1D344; 0x1D345; 0x1D346; 0x1D347; 0x1D348; 0x1D349; 0x1D34A; 0x1D34B;
    0x1D34C; 0x1D34D; 0x1D34E; 0x1D34F; 0x1D350; 0x1D351; 0x1D352; 0x1D353;
    0x1D354; 0x1D355; 0x1D356; 0x1D6C1; 0x1D6DB; 0x1D6FB; 0x1D715; 0x1D735;
    0x1D74F; 0x1D76F; 0x1D789; 0x1D7A9; 0x1D7C3; 0x1D800; 0x1D801; 0x1D802;
    0x1D803; 0x1D804; 0x1D805; 0x1D806; 0x1D807; 0x1D808; 0x1D809; 0x1D80A;
    0x1D80B; 0x1D80C; 0x1D80D; 0x1D80E; 0x1D80F; 0x1D810; 0x1D811; 0x1D812;
    0x1D813; 0x1D814; 0x1D815; 0x1D816; 0x1D817; 0x1D818; 0x1D819; 0x1D81A;
    0x1D81B; 0x1D81C; 0x1D81D; 0x1D81E; 0x1D81F; 0x1D820; 0x1D821; 0x1D822;
    0x1D823; 0x1D824; 0x1D825; 0x1D826; 0x1D827; 0x1D828; 0x1D829; 0x1D82A;
    0x1D82B; 0x1D82C; 0x1D82D; 0x1D82E; 0x1D82F; 0x1D830; 0x1D831; 0x1D832;
    0x1D833; 0x1D834; 0x1D835; 0x1D836; 0x1D837; 0x1D838; 0x1D839; 0x1D83A;
    0x1D83B; 0x1D83C; 0x1D83D; 0x1D83E; 0x1D83F; 0x1D840; 0x1D841; 0x1D842;
    0x1D843; 0x1D844; 0x1D845; 0x1D846; 0x1D847; 0x1D848; 0x1D849; 0x1D84A;
    0x1D84B; 0x1D84C; 0x1D84D; 0x1D84E; 0x1D84F; 0x1D850; 0x1D851; 0x1D852;
    0x1D853; 0x1D854; 0x1D855; 0x1D856; 0x1D857; 0x1D858; 0x1D859; 0x1D85A;
    0x1D85B; 0x1D85C; 0x1D85D; 0x1D85E; 0x1D85F; 0x1D860; 0x1D861; 0x1D862;
    0x1D863; 0x1D864; 0x1D865; 0x1D866; 0x1D867; 0x1D868; 0x1D869; 0x1D86A;
    0x1D86B; 0x1D86C; 0x1D86D; 0x1D86E; 0x1D86F; 0x1D870; 0x1D871; 0x1D872;
    0x1D873; 0x1D874; 0x1D875; 0x1D876; 0x1D877; 0x1D878; 0x1D879; 0x1D87A;
    0x1D87B; 0x1D87C; 0x1D87D; 0x1D87E; 0x1D87F; 0x1D880; 0x1D881; 0x1D882;
    0x1D883; 0x1D884; 0x1D885; 0x1D886; 0x1D887; 0x1D888; 0x1D889; 0x1D88A;
    0x1D88B; 0x1D88C; 0x1D88D; 0x1D88E; 0x1D88F; 0x1D890; 0x1D891; 0x1D892;
    0x1D893; 0x1D894; 0x1D895; 0x1D896; 0x1D897; 0x1D898; 0x1D899; 0x1D89A;
    0x1D89B; 0x1D89C; 0x1D89D; 0x1D89E; 0x1D89F; 0x1D8A0; 0x1D8A1; 0x1D8A2;
    0x1D8A3; 0x1D8A4; 0x1D8A5; 0x1D8A6; 0x1D8A7; 0x1D8A8; 0x1D8A9; 0x1D8AA;
    0x1D8AB; 0x1D8AC; 0x1D8AD; 0x1D8AE; 0x1D8AF; 0x1D8B0; 0x1D8B1; 0x1D8B2;
    0x1D8B3; 0x1D8B4; 0x1D8B5; 0x1D8B6; 0x1D8B7; 0x1D8B8; 0x1D8B9; 0x1D8BA;
    0x1D8BB; 0x1D8BC; 0x1D8BD; 0x1D8BE; 0x1D8BF; 0x1D8C0; 0x1D8C1; 0x1D8C2;
    0x1D8C3; 0x1D8C4; 0x1D8C5; 0x1D8C6; 0x1D8C7; 0x1D8C8; 0x1D8C9; 0x1D8CA;
    0x1D8CB; 0x1D8CC; 0x1D8CD; 0x1D8CE; 0x1D8CF; 0x1D8D0; 0x1D8D1; 0x1D8D2;
    0x1D8D3; 0x1D8D4; 0x1D8D5; 0x1D8D6; 0x1D8D7; 0x1D8D8; 0x1D8D9; 0x1D8DA;
    0x1D8DB; 0x1D8DC; 0x1D8DD; 0x1D8DE; 0x1D8DF; 0x1D8E0; 0x1D8E1; 0x1D8E2;
    0x1D8E3; 0x1D8E4; 0x1D8E5; 0x1D8E6; 0x1D8E7; 0x1D8E8; 0x1D8E9; 0x1D8EA;
    0x1D8EB; 0x1D8EC; 0x1D8ED; 0x1D8EE; 0x1D8EF; 0x1D8F0; 0x1D8F1; 0x1D8F2;
    0x1D8F3; 0x1D8F4; 0x1D8F5; 0x1D8F6; 0x1D8F7; 0x1D8F8; 0x1D8F9; 0x1D8FA;
    0x1D8FB; 0x1D8FC; 0x1D8FD; 0x1D8FE; 0x1D8FF; 0x1D900; 0x1D901; 0x1D902;
    0x1D903; 0x1D904; 0x1D905; 0x1D906; 0x1D907; 0x1D908; 0x1D909; 0x1D90A;
    0x1D90B; 0x1D90C; 0x1D90D; 0x1D90E; 0x1D90F; 0x1D910; 0x1D911; 0x1D912;
    0x1D913; 0x1D914; 0x1D915; 0x1D916; 0x1D917; 0x1D918; 0x1D919; 0x1D91A;
    0x1D91B; 0x1D91C; 0x1D91D; 0x1D91E; 0x1D91F; 0x1D920; 0x1D921; 0x1D922;
    0x1D923; 0x1D924; 0x1D925; 0x1D926; 0x1D927; 0x1D928; 0x1D929; 0x1D92A;
    0x1D92B; 0x1D92C; 0x1D92D; 0x1D92E; 0x1D92F; 0x1D930; 0x1D931; 0x1D932;
    0x1D933; 0x1D934; 0x1D935; 0x1D936; 0x1D937; 0x1D938; 0x1D939; 0x1D93A;
    0x1D93B; 0x1D93C; 0x1D93D; 0x1D93E; 0x1D93F; 0x1D940; 0x1D941; 0x1D942;
    0x1D943; 0x1D944; 0x1D945; 0x1D946; 0x1D947; 0x1D948; 0x1D949; 0x1D94A;
    0x1D94B; 0x1D94C; 0x1D94D; 0x1D94E; 0x1D94F; 0x1D950; 0x1D951; 0x1D952;
    0x1D953; 0x1D954; 0x1D955; 0x1D956; 0x1D957; 0x1D958; 0x1D959; 0x1D95A;
    0x1D95B; 0x1D95C; 0x1D95D; 0x1D95E; 0x1D95F; 0x1D960; 0x1D961; 0x1D962;
    0x1D963; 0x1D964; 0x1D965; 0x1D966; 0x1D967; 0x1D968; 0x1D969; 0x1D96A;
    0x1D96B; 0x1D96C; 0x1D96D; 0x1D96E; 0x1D96F; 0x1D970; 0x1D971; 0x1D972;
    0x1D973; 0x1D974; 0x1D975; 0x1D976; 0x1D977; 0x1D978; 0x1D979; 0x1D97A;
    0x1D97B; 0x1D97C; 0x1D97D; 0x1D97E; 0x1D97F; 0x1D980; 0x1D981; 0x1D982;
    0x1D983; 0x1D984; 0x1D985; 0x1D986; 0x1D987; 0x1D988; 0x1D989; 0x1D98A;
    0x1D98B; 0x1D98C; 0x1D98D; 0x1D98E; 0x1D98F; 0x1D990; 0x1D991; 0x1D992;
    0x1D993; 0x1D994; 0x1D995; 0x1D996; 0x1D997; 0x1D998; 0x1D999; 0x1D99A;
    0x1D99B; 0x1D99C; 0x1D99D; 0x1D99E; 0x1D99F; 0x1D9A0; 0x1D9A1; 0x1D9A2;
    0x1D9A3; 0x1D9A4; 0x1D9A5; 0x1D9A6; 0x1D9A7; 0x1D9A8; 0x1D9A9; 0x1D9AA;
    0x1D9AB; 0x1D9AC; 0x1D9AD; 0x1D9AE; 0x1D9AF; 0x1D9B0; 0x1D9B1; 0x1D9B2;
    0x1D9B3; 0x1D9B4; 0x1D9B5; 0x1D9B6; 0x1D9B7; 0x1D9B8; 0x1D9B9; 0x1D9BA;
    0x1D9BB; 0x1D9BC; 0x1D9BD; 0x1D9BE; 0x1D9BF; 0x1D9C0; 0x1D9C1; 0x1D9C2;
    0x1D9C3; 0x1D9C4; 0x1D9C5; 0x1D9C6; 0x1D9C7; 0x1D9C8; 0x1D9C9; 0x1D9CA;
    0x1D9CB; 0x1D9CC; 0x1D9CD; 0x1D9CE; 0x1D9CF; 0x1D9D0; 0x1D9D1; 0x1D9D2;
    0x1D9D3; 0x1D9D4; 0x1D9D5; 0x1D9D6; 0x1D9D7; 0x1D9D8; 0x1D9D9; 0x1D9DA;
    0x1D9DB; 0x1D9DC; 0x1D9DD; 0x1D9DE; 0x1D9DF; 0x1D9E0; 0x1D9E1; 0x1D9E2;
    0x1D9E3; 0x1D9E4; 0x1D9E5; 0x1D9E6; 0x1D9E7; 0x1D9E8; 0x1D9E9; 0x1D9EA;
    0x1D9EB; 0x1D9EC; 0x1D9ED; 0x1D9EE; 0x1D9EF; 0x1D9F0; 0x1D9F1; 0x1D9F2;
    0x1D9F3; 0x1D9F4; 0x1D9F5; 0x1D9F6; 0x1D9F7; 0x1D9F8; 0x1D9F9; 0x1D9FA;
    0x1D9FB; 0x1D9FC; 0x1D9FD; 0x1D9FE; 0x1D9FF; 0x1DA37; 0x1DA38; 0x1DA39;
    0x1DA3A; 0x1DA6D; 0x1DA6E; 0x1DA6F; 0x1DA70; 0x1DA71; 0x1DA72; 0x1DA73;
    0x1DA74; 0x1DA76; 0x1DA77; 0x1DA78; 0x1DA79; 0x1DA7A; 0x1DA7B; 0x1DA7C;
    0x1DA7D; 0x1DA7E; 0x1DA7F; 0x1DA80; 0x1DA81; 0x1DA82; 0x1DA83; 0x1DA85;
    0x1DA86; 0x1DA87; 0x1DA88; 0x1DA89; 0x1DA8A; 0x1DA8B; 0x1E14F; 0x1E2FF;
    0x1E5FF; 0x1E95E; 0x1E95F; 0x1ECAC; 0x1ECB0; 0x1ED2E; 0x1EEF0; 0x1EEF1;
    0x1F000; 0x1F001; 0x1F002; 0x1F003; 0x1F004; 0x1F005; 0x1F006; 0x1F007;
    0x1F008; 0x1F009; 0x1F00A; 0x1F00B; 0x1F00C; 0x1F00D; 0x1F00E; 0x1F00F;
    0x1F010; 0x1F011; 0x1F012; 0x1F013; 0x1F014; 0x1F015; 0x1F016; 0x1F017;
    0x1F018; 0x1F019; 0x1F01A; 0x1F01B; 0x1F01C; 0x1F01D; 0x1F01E; 0x1F01F;
    0x1F020; 0x1F021; 0x1F022; 0x1F023; 0x1F024; 0x1F025; 0x1F026; 0x1F027;
    0x1F028; 0x1F029; 0x1F02A; 0x1F02B; 0x1F030; 0x1F031; 0x1F032; 0x1F033;
    0x1F034; 0x1F035; 0x1F036; 0x1F037; 0x1F038; 0x1F039; 0x1F03A; 0x1F03B;
    0x1F03C; 0x1F03D; 0x1F03E; 0x1F03F; 0x1F040; 0x1F041; 0x1F042; 0x1F043;
    0x1F044; 0x1F045; 0x1F046; 0x1F047; 0x1F048; 0x1F049; 0x1F04A; 0x1F04B;
    0x1F04C; 0x1F04D; 0x1F04E; 0x1F04F; 0x1F050; 0x1F051; 0x1F052; 0x1F053;
    0x1F054; 0x1F055; 0x1F056; 0x1F057; 0x1F058; 0x1F059; 0x1F05A; 0x1F05B;
    0x1F05C; 0x1F05D; 0x1F05E; 0x1F05F; 0x1F060; 0x1F061; 0x1F062; 0x1F063;
    0x1F064; 0x1F065; 0x1F066; 0x1F067; 0x1F068; 0x1F069; 0x1F06A; 0x1F06B;
    0x1F06C; 0x1F06D; 0x1F06E; 0x1F06F; 0x1F070; 0x1F071; 0x1F072; 0x1F073;
    0x1F074; 0x1F075; 0x1F076; 0x1F077; 0x1F078; 0x1F079; 0x1F07A; 0x1F07B;
    0x1F07C; 0x1F07D; 0x1F07E; 0x1F07F; 0x1F080; 0x1F081; 0x1F082; 0x1F083;
    0x1F084; 0x1F085; 0x1F086; 0x1F087; 0x1F088; 0x1F089; 0x1F08A; 0x1F08B;
    0x1F08C; 0x1F08D; 0x1F08E; 0x1F08F; 0x1F090; 0x1F091; 0x1F092; 0x1F093;
    0x1F0A0; 0x1F0A1; 0x1F0A2; 0x1F0A3; 0x1F0A4; 0x1F0A5; 0x1F0A6; 0x1F0A7;
    0x1F0A8; 0x1F0A9; 0x1F0AA; 0x1F0AB; 0x1F0AC; 0x1F0AD; 0x1F0AE; 0x1F0B1;
    0x1F0B2; 0x1F0B3; 0x1F0B4; 0x1F0B5; 0x1F0B6; 0x1F0B7; 0x1F0B8; 0x1F0B9;
    0x1F0BA; 0x1F0BB; 0x1F0BC; 0x1F0BD; 0x1F0BE; 0x1F0BF; 0x1F0C1; 0x1F0C2;
    0x1F0C3; 0x1F0C4; 0x1F0C5; 0x1F0C6; 0x1F0C7; 0x1F0C8; 0x1F0C9; 0x1F0CA;
    0x1F0CB; 0x1F0CC; 0x1F0CD; 0x1F0CE; 0x1F0CF; 0x1F0D1; 0x1F0D2; 0x1F0D3;
    0x1F0D4; 0x1F0D5; 0x1F0D6; 0x1F0D7; 0x1F0D8; 0x1F0D9; 0x1F0DA; 0x1F0DB;
    0x1F0DC; 0x1F0DD; 0x1F0DE; 0x1F0DF; 0x1F0E0; 0x1F0E1; 0x1F0E2; 0x1F0E3;
    0x1F0E4; 0x1F0E5; 0x1F0E6; 0x1F0E7; 0x1F0E8; 0x1F0E9; 0x1F0EA; 0x1F0EB;
    0x1F0EC; 0x1F0ED; 0x1F0EE; 0x1F0EF; 0x1F0F0; 0x1F0F1; 0x1F0F2; 0x1F0F3;
    0x1F0F4; 0x1F0F5; 0x1F10D; 0x1F10E; 0x1F10F; 0x1F110; 0x1F111; 0x1F112;
    0x1F113; 0x1F114; 0x1F115; 0x1F116; 0x1F117; 0x1F118; 0x1F119; 0x1F11A;
    0x1F11B; 0x1F11C; 0x1F11D; 0x1F11E; 0x1F11F; 0x1F120; 0x1F121; 0x1F122;
    0x1F123; 0x1F124; 0x1F125; 0x1F126; 0x1F127; 0x1F128; 0x1F129; 0x1F12A;
    0x1F12B; 0x1F12C; 0x1F12D; 0x1F12E; 0x1F12F; 0x1F130; 0x1F131; 0x1F132;
    0x1F133; 0x1F134; 0x1F135; 0x1F136; 0x1F137; 0x1F138; 0x1F139; 0x1F13A;
    0x1F13B; 0x1F13C; 0x1F13D; 0x1F13E; 0x1F13F; 0x1F140; 0x1F141; 0x1F142;
    0x1F143; 0x1F144; 0x1F145; 0x1F146; 0x1F147; 0x1F148; 0x1F149; 0x1F14A;
    0x1F14B; 0x1F14C; 0x1F14D; 0x1F14E; 0x1F14F; 0x1F150; 0x1F151; 0x1F152;
    0x1F153; 0x1F154; 0x1F155; 0x1F156; 0x1F157; 0x1F158; 0x1F159; 0x1F15A;
    0x1F15B; 0x1F15C; 0x1F15D; 0x1F15E; 0x1F15F; 0x1F160; 0x1F161; 0x1F162;
    0x1F163; 0x1F164; 0x1F165; 0x1F166; 0x1F167; 0x1F168; 0x1F169; 0x1F16A;
    0x1F16B; 0x1F16C; 0x1F16D; 0x1F16E; 0x1F16F; 0x1F170; 0x1F171; 0x1F172;
    0x1F173; 0x1F174; 0x1F175; 0x1F176; 0x1F177; 0x1F178; 0x1F179; 0x1F17A;
    0x1F17B; 0x1F17C; 0x1F17D; 0x1F17E; 0x1F17F; 0x1F180; 0x1F181; 0x1F182;
    0x1F183; 0x1F184; 0x1F185; 0x1F186; 0x1F187; 0x1F188; 0x1F189; 0x1F18A;
    0x1F18B; 0x1F18C; 0x1F18D; 0x1F18E; 0x1F18F; 0x1F190; 0x1F191; 0x1F192;
    0x1F193; 0x1F194; 0x1F195; 0x1F196; 0x1F197; 0x1F198; 0x1F199; 0x1F19A;
    0x1F19B; 0x1F19C; 0x1F19D; 0x1F19E; 0x1F19F; 0x1F1A0; 0x1F1A1; 0x1F1A2;
    0x1F1A3; 0x1F1A4; 0x1F1A5; 0x1F1A6; 0x1F1A7; 0x1F1A8; 0x1F1A9; 0x1F1AA;
    0x1F1AB; 0x1F1AC; 0x1F1AD; 0x1F1E6; 0x1F1E7; 0x1F1E8; 0x1F1E9; 0x1F1EA;
    0x1F1EB; 0x1F1EC; 0x1F1ED; 0x1F1EE; 0x1F1EF; 0x1F1F0; 0x1F1F1; 0x1F1F2;
    0x1F1F3; 0x1F1F4; 0x1F1F5; 0x1F1F6; 0x1F1F7; 0x1F1F8; 0x1F1F9; 0x1F1FA;
    0x1F1FB; 0x1F1FC; 0x1F1FD; 0x1F1FE; 0x1F1FF; 0x1F200; 0x1F201; 0x1F202;
    0x1F210; 0x1F211; 0x1F212; 0x1F213; 0x1F214; 0x1F215; 0x1F216; 0x1F217;
    0x1F218; 0x1F219; 0x1F21A; 0x1F21B; 0x1F21C; 0x1F21D; 0x1F21E; 0x1F21F;
    0x1F220; 0x1F221; 0x1F222; 0x1F223; 0x1F224; 0x1F225; 0x1F226; 0x1F227;
    0x1F228; 0x1F229; 0x1F22A; 0x1F22B; 0x1F22C; 0x1F22D; 0x1F22E; 0x1F22F;
    0x1F230; 0x1F231; 0x1F232; 0x1F233; 0x1F234; 0x1F235; 0x1F236; 0x1F237;
    0x1F238; 0x1F239; 0x1F23A; 0x1F23B; 0x1F240; 0x1F241; 0x1F242; 0x1F243;
    0x1F244; 0x1F245; 0x1F246; 0x1F247; 0x1F248; 0x1F250; 0x1F251; 0x1F260;
    0x1F261; 0x1F262; 0x1F263; 0x1F264; 0x1F265; 0x1F300; 0x1F301; 0x1F302;
    0x1F303; 0x1F304; 0x1F305; 0x1F306; 0x1F307; 0x1F308; 0x1F309; 0x1F30A;
    0x1F30B; 0x1F30C; 0x1F30D; 0x1F30E; 0x1F30F; 0x1F310; 0x1F311; 0x1F312;
    0x1F313; 0x1F314; 0x1F315; 0x1F316; 0x1F317; 0x1F318; 0x1F319; 0x1F31A;
    0x1F31B; 0x1F31C; 0x1F31D; 0x1F31E; 0x1F31F; 0x1F320; 0x1F321; 0x1F322;
    0x1F323; 0x1F324; 0x1F325; 0x1F326; 0x1F327; 0x1F328; 0x1F329; 0x1F32A;
    0x1F32B; 0x1F32C; 0x1F32D; 0x1F32E; 0x1F32F; 0x1F330; 0x1F331; 0x1F332;
    0x1F333; 0x1F334; 0x1F335; 0x1F336; 0x1F337; 0x1F338; 0x1F339; 0x1F33A;
    0x1F33B; 0x1F33C; 0x1F33D; 0x1F33E; 0x1F33F; 0x1F340; 0x1F341; 0x1F342;
    0x1F343; 0x1F344; 0x1F345; 0x1F346; 0x1F347; 0x1F348; 0x1F349; 0x1F34A;
    0x1F34B; 0x1F34C; 0x1F34D; 0x1F34E; 0x1F34F; 0x1F350; 0x1F351; 0x1F352;
    0x1F353; 0x1F354; 0x1F355; 0x1F356; 0x1F357; 0x1F358; 0x1F359; 0x1F35A;
    0x1F35B; 0x1F35C; 0x1F35D; 0x1F35E; 0x1F35F; 0x1F360; 0x1F361; 0x1F362;
    0x1F363; 0x1F364; 0x1F365; 0x1F366; 0x1F367; 0x1F368; 0x1F369; 0x1F36A;
    0x1F36B; 0x1F36C; 0x1F36D; 0x1F36E; 0x1F36F; 0x1F370; 0x1F371; 0x1F372;
    0x1F373; 0x1F374; 0x1F375; 0x1F376; 0x1F377; 0x1F378; 0x1F379; 0x1F37A;
    0x1F37B; 0x1F37C; 0x1F37D; 0x1F37E; 0x1F37F; 0x1F380; 0x1F381; 0x1F382;
    0x1F383; 0x1F384; 0x1F385; 0x1F386; 0x1F387; 0x1F388; 0x1F389; 0x1F38A;
    0x1F38B; 0x1F38C; 0x1F38D; 0x1F38E; 0x1F38F; 0x1F390; 0x1F391; 0x1F392;
    0x1F393; 0x1F394; 0x1F395; 0x1F396; 0x1F397; 0x1F398; 0x1F399; 0x1F39A;
    0x1F39B; 0x1F39C; 0x1F39D; 0x1F39E; 0x1F39F; 0x1F3A0; 0x1F3A1; 0x1F3A2;
    0x1F3A3; 0x1F3A4; 0x1F3A5; 0x1F3A6; 0x1F3A7; 0x1F3A8; 0x1F3A9; 0x1F3AA;
    0x1F3AB; 0x1F3AC; 0x1F3AD; 0x1F3AE; 0x1F3AF; 0x1F3B0; 0x1F3B1; 0x1F3B2;
    0x1F3B3; 0x1F3B4; 0x1F3B5; 0x1F3B6; 0x1F3B7; 0x1F3B8; 0x1F3B9; 0x1F3BA;
    0x1F3BB; 0x1F3BC; 0x1F3BD; 0x1F3BE; 0x1F3BF; 0x1F3C0; 0x1F3C1; 0x1F3C2;
    0x1F3C3; 0x1F3C4; 0x1F3C5; 0x1F3C6; 0x1F3C7; 0x1F3C8; 0x1F3C9; 0x1F3CA;
    0x1F3CB; 0x1F3CC; 0x1F3CD; 0x1F3CE; 0x1F3CF; 0x1F3D0; 0x1F3D1; 0x1F3D2;
    0x1F3D3; 0x1F3D4; 0x1F3D5; 0x1F3D6; 0x1F3D7; 0x1F3D8; 0x1F3D9; 0x1F3DA;
    0x1F3DB; 0x1F3DC; 0x1F3DD; 0x1F3DE; 0x1F3DF; 0x1F3E0; 0x1F3E1; 0x1F3E2;
    0x1F3E3; 0x1F3E4; 0x1F3E5; 0x1F3E6; 0x1F3E7; 0x1F3E8; 0x1F3E9; 0x1F3EA;
    0x1F3EB; 0x1F3EC; 0x1F3ED; 0x1F3EE; 0x1F3EF; 0x1F3F0; 0x1F3F1; 0x1F3F2;
    0x1F3F3; 0x1F3F4; 0x1F3F5; 0x1F3F6; 0x1F3F7; 0x1F3F8; 0x1F3F9; 0x1F3FA;
    0x1F3FB; 0x1F3FC; 0x1F3FD; 0x1F3FE; 0x1F3FF; 0x1F400; 0x1F401; 0x1F402;
    0x1F403; 0x1F404; 0x1F405; 0x1F406; 0x1F407; 0x1F408; 0x1F409; 0x1F40A;
    0x1F40B; 0x1F40C; 0x1F40D; 0x1F40E; 0x1F40F; 0x1F410; 0x1F411; 0x1F412;
    0x1F413; 0x1F414; 0x1F415; 0x1F416; 0x1F417; 0x1F418; 0x1F419; 0x1F41A;
    0x1F41B; 0x1F41C; 0x1F41D; 0x1F41E; 0x1F41F; 0x1F420; 0x1F421; 0x1F422;
    0x1F423; 0x1F424; 0x1F425; 0x1F426; 0x1F427; 0x1F428; 0x1F429; 0x1F42A;
    0x1F42B; 0x1F42C; 0x1F42D; 0x1F42E; 0x1F42F; 0x1F430; 0x1F431; 0x1F432;
    0x1F433; 0x1F434; 0x1F435; 0x1F436; 0x1F437; 0x1F438; 0x1F439; 0x1F43A;
    0x1F43B; 0x1F43C; 0x1F43D; 0x1F43E; 0x1F43F; 0x1F440; 0x1F441; 0x1F442;
    0x1F443; 0x1F444; 0x1F445; 0x1F446; 0x1F447; 0x1F448; 0x1F449; 0x1F44A;
    0x1F44B; 0x1F44C; 0x1F44D; 0x1F44E; 0x1F44F; 0x1F450; 0x1F451; 0x1F452;
    0x1F453; 0x1F454; 0x1F455; 0x1F456; 0x1F457; 0x1F458; 0x1F459; 0x1F45A;
    0x1F45B; 0x1F45C; 0x1F45D; 0x1F45E; 0x1F45F; 0x1F460; 0x1F461; 0x1F462;
    0x1F463; 0x1F464; 0x1F465; 0x1F466; 0x1F467; 0x1F468; 0x1F469; 0x1F46A;
    0x1F46B; 0x1F46C; 0x1F46D; 0x1F46E; 0x1F46F; 0x1F470; 0x1F471; 0x1F472;
    0x1F473; 0x1F474; 0x1F475; 0x1F476; 0x1F477; 0x1F478; 0x1F479; 0x1F47A;
    0x1F47B; 0x1F47C; 0x1F47D; 0x1F47E; 0x1F47F; 0x1F480; 0x1F481; 0x1F482;
    0x1F483; 0x1F484; 0x1F485; 0x1F486; 0x1F487; 0x1F488; 0x1F489; 0x1F48A;
    0x1F48B; 0x1F48C; 0x1F48D; 0x1F48E; 0x1F48F; 0x1F490; 0x1F491; 0x1F492;
    0x1F493; 0x1F494; 0x1F495; 0x1F496; 0x1F497; 0x1F498; 0x1F499; 0x1F49A;
    0x1F49B; 0x1F49C; 0x1F49D; 0x1F49E; 0x1F49F; 0x1F4A0; 0x1F4A1; 0x1F4A2;
    0x1F4A3; 0x1F4A4; 0x1F4A5; 0x1F4A6; 0x1F4A7; 0x1F4A8; 0x1F4A9; 0x1F4AA;
    0x1F4AB; 0x1F4AC; 0x1F4AD; 0x1F4AE; 0x1F4AF; 0x1F4B0; 0x1F4B1; 0x1F4B2;
    0x1F4B3; 0x1F4B4; 0x1F4B5; 0x1F4B6; 0x1F4B7; 0x1F4B8; 0x1F4B9; 0x1F4BA;
    0x1F4BB; 0x1F4BC; 0x1F4BD; 0x1F4BE; 0x1F4BF; 0x1F4C0; 0x1F4C1; 0x1F4C2;
    0x1F4C3; 0x1F4C4; 0x1F4C5; 0x1F4C6; 0x1F4C7; 0x1F4C8; 0x1F4C9; 0x1F4CA;
    0x1F4CB; 0x1F4CC; 0x1F4CD; 0x1F4CE; 0x1F4CF; 0x1F4D0; 0x1F4D1; 0x1F4D2;
    0x1F4D3; 0x1F4D4; 0x1F4D5; 0x1F4D6; 0x1F4D7; 0x1F4D8; 0x1F4D9; 0x1F4DA;
    0x1F4DB; 0x1F4DC; 0x1F4DD; 0x1F4DE; 0x1F4DF; 0x1F4E0; 0x1F4E1; 0x1F4E2;
    0x1F4E3; 0x1F4E4; 0x1F4E5; 0x1F4E6; 0x1F4E7; 0x1F4E8; 0x1F4E9; 0x1F4EA;
    0x1F4EB; 0x1F4EC; 0x1F4ED; 0x1F4EE; 0x1F4EF; 0x1F4F0; 0x1F4F1; 0x1F4F2;
    0x1F4F3; 0x1F4F4; 0x1F4F5; 0x1F4F6; 0x1F4F7; 0x1F4F8; 0x1F4F9; 0x1F4FA;
    0x1F4FB; 0x1F4FC; 0x1F4FD; 0x1F4FE; 0x1F4FF; 0x1F500; 0x1F501; 0x1F502;
    0x1F503; 0x1F504; 0x1F505; 0x1F506; 0x1F507; 0x1F508; 0x1F509; 0x1F50A;
    0x1F50B; 0x1F50C; 0x1F50D; 0x1F50E; 0x1F50F; 0x1F510; 0x1F511; 0x1F512;
    0x1F513; 0x1F514; 0x1F515; 0x1F516; 0x1F517; 0x1F518; 0x1F519; 0x1F51A;
    0x1F51B; 0x1F51C; 0x1F51D; 0x1F51E; 0x1F51F; 0x1F520; 0x1F521; 0x1F522;
    0x1F523; 0x1F524; 0x1F525; 0x1F526; 0x1F527; 0x1F528; 0x1F529; 0x1F52A;
    0x1F52B; 0x1F52C; 0x1F52D; 0x1F52E; 0x1F52F; 0x1F530; 0x1F531; 0x1F532;
    0x1F533; 0x1F534; 0x1F535; 0x1F536; 0x1F537; 0x1F538; 0x1F539; 0x1F53A;
    0x1F53B; 0x1F53C; 0x1F53D; 0x1F53E; 0x1F53F; 0x1F540; 0x1F541; 0x1F542;
    0x1F543; 0x1F544; 0x1F545; 0x1F546; 0x1F547; 0x1F548; 0x1F549; 0x1F54A;
    0x1F54B; 0x1F54C; 0x1F54D; 0x1F54E; 0x1F54F; 0x1F550; 0x1F551; 0x1F552;
    0x1F553; 0x1F554; 0x1F555; 0x1F556; 0x1F557; 0x1F558; 0x1F559; 0x1F55A;
    0x1F55B; 0x1F55C; 0x1F55D; 0x1F55E; 0x1F55F; 0x1F560; 0x1F561; 0x1F562;
    0x1F563; 0x1F564; 0x1F565; 0x1F566; 0x1F567; 0x1F568; 0x1F569; 0x1F56A;
    0x1F56B; 0x1F56C; 0x1F56D; 0x1F56E; 0x1F56F; 0x1F570; 0x1F571; 0x1F572;
    0x1F573; 0x1F574; 0x1F575; 0x1F576; 0x1F577; 0x1F578; 0x1F579; 0x1F57A;
    0x1F57B; 0x1F57C; 0x1F57D; 0x1F57E; 0x1F57F; 0x1F580; 0x1F581; 0x1F582;
    0x1F583; 0x1F584; 0x1F585; 0x1F586; 0x1F587; 0x1F588; 0x1F589; 0x1F58A;
    0x1F58B; 0x1F58C; 0x1F58D; 0x1F58E; 0x1F58F; 0x1F590; 0x1F591; 0x1F592;
    0x1F593; 0x1F594; 0x1F595; 0x1F596; 0x1F597; 0x1F598; 0x1F599; 0x1F59A;
    0x1F59B; 0x1F59C; 0x1F59D; 0x1F59E; 0x1F59F; 0x1F5A0; 0x1F5A1; 0x1F5A2;
    0x1F5A3; 0x1F5A4; 0x1F5A5; 0x1F5A6; 0x1F5A7; 0x1F5A8; 0x1F5A9; 0x1F5AA;
    0x1F5AB; 0x1F5AC; 0x1F5AD; 0x1F5AE; 0x1F5AF; 0x1F5B0; 0x1F5B1; 0x1F5B2;
    0x1F5B3; 0x1F5B4; 0x1F5B5; 0x1F5B6; 0x1F5B7; 0x1F5B8; 0x1F5B9; 0x1F5BA;
    0x1F5BB; 0x1F5BC; 0x1F5BD; 0x1F5BE; 0x1F5BF; 0x1F5C0; 0x1F5C1; 0x1F5C2;
    0x1F5C3; 0x1F5C4; 0x1F5C5; 0x1F5C6; 0x1F5C7; 0x1F5C8; 0x1F5C9; 0x1F5CA;
    0x1F5CB; 0x1F5CC; 0x1F5CD; 0x1F5CE; 0x1F5CF; 0x1F5D0; 0x1F5D1; 0x1F5D2;
    0x1F5D3; 0x1F5D4; 0x1F5D5; 0x1F5D6; 0x1F5D7; 0x1F5D8; 0x1F5D9; 0x1F5DA;
    0x1F5DB; 0x1F5DC; 0x1F5DD; 0x1F5DE; 0x1F5DF; 0x1F5E0; 0x1F5E1; 0x1F5E2;
    0x1F5E3; 0x1F5E4; 0x1F5E5; 0x1F5E6; 0x1F5E7; 0x1F5E8; 0x1F5E9; 0x1F5EA;
    0x1F5EB; 0x1F5EC; 0x1F5ED; 0x1F5EE; 0x1F5EF; 0x1F5F0; 0x1F5F1; 0x1F5F2;
    0x1F5F3; 0x1F5F4; 0x1F5F5; 0x1F5F6; 0x1F5F7; 0x1F5F8; 0x1F5F9; 0x1F5FA;
    0x1F5FB; 0x1F5FC; 0x1F5FD; 0x1F5FE; 0x1F5FF; 0x1F600; 0x1F601; 0x1F602;
    0x1F603; 0x1F604; 0x1F605; 0x1F606; 0x1F607; 0x1F608; 0x1F609; 0x1F60A;
    0x1F60B; 0x1F60C; 0x1F60D; 0x1F60E; 0x1F60F; 0x1F610; 0x1F611; 0x1F612;
    0x1F613; 0x1F614; 0x1F615; 0x1F616; 0x1F617; 0x1F618; 0x1F619; 0x1F61A;
    0x1F61B; 0x1F61C; 0x1F61D; 0x1F61E; 0x1F61F; 0x1F620; 0x1F621; 0x1F622;
    0x1F623; 0x1F624; 0x1F625; 0x1F626; 0x1F627; 0x1F628; 0x1F629; 0x1F62A;
    0x1F62B; 0x1F62C; 0x1F62D; 0x1F62E; 0x1F62F; 0x1F630; 0x1F631; 0x1F632;
    0x1F633; 0x1F634; 0x1F635; 0x1F636; 0x1F637; 0x1F638; 0x1F639; 0x1F63A;
    0x1F63B; 0x1F63C; 0x1F63D; 0x1F63E; 0x1F63F; 0x1F640; 0x1F641; 0x1F642;
    0x1F643; 0x1F644; 0x1F645; 0x1F646; 0x1F647; 0x1F648; 0x1F649; 0x1F64A;
    0x1F64B; 0x1F64C; 0x1F64D; 0x1F64E; 0x1F64F; 0x1F650; 0x1F651; 0x1F652;
    0x1F653; 0x1F654; 0x1F655; 0x1F656; 0x1F657; 0x1F658; 0x1F659; 0x1F65A;
    0x1F65B; 0x1F65C; 0x1F65D; 0x1F65E; 0x1F65F; 0x1F660; 0x1F661; 0x1F662;
    0x1F663; 0x1F664; 0x1F665; 0x1F666; 0x1F667; 0x1F668; 0x1F669; 0x1F66A;
    0x1F66B; 0x1F66C; 0x1F66D; 0x1F66E; 0x1F66F; 0x1F670; 0x1F671; 0x1F672;
    0x1F673; 0x1F674; 0x1F675; 0x1F676; 0x1F677; 0x1F678; 0x1F679; 0x1F67A;
    0x1F67B; 0x1F67C; 0x1F67D; 0x1F67E; 0x1F67F; 0x1F680; 0x1F681; 0x1F682;
    0x1F683; 0x1F684; 0x1F685; 0x1F686; 0x1F687; 0x1F688; 0x1F689; 0x1F68A;
    0x1F68B; 0x1F68C; 0x1F68D; 0x1F68E; 0x1F68F; 0x1F690; 0x1F691; 0x1F692;
    0x1F693; 0x1F694; 0x1F695; 0x1F696; 0x1F697; 0x1F698; 0x1F699; 0x1F69A;
    0x1F69B; 0x1F69C; 0x1F69D; 0x1F69E; 0x1F69F; 0x1F6A0; 0x1F6A1; 0x1F6A2;
    0x1F6A3; 0x1F6A4; 0x1F6A5; 0x1F6A6; 0x1F6A7; 0x1F6A8; 0x1F6A9; 0x1F6AA;
    0x1F6AB; 0x1F6AC; 0x1F6AD; 0x1F6AE; 0x1F6AF; 0x1F6B0; 0x1F6B1; 0x1F6B2;
    0x1F6B3; 0x1F6B4; 0x1F6B5; 0x1F6B6; 0x1F6B7; 0x1F6B8; 0x1F6B9; 0x1F6BA;
    0x1F6BB; 0x1F6BC; 0x1F6BD; 0x1F6BE; 0x1F6BF; 0x1F6C0; 0x1F6C1; 0x1F6C2;
    0x1F6C3; 0x1F6C4; 0x1F6C5; 0x1F6C6; 0x1F6C7; 0x1F6C8; 0x1F6C9; 0x1F6CA;
    0x1F6CB; 0x1F6CC; 0x1F6CD; 0x1F6CE; 0x1F6CF; 0x1F6D0; 0x1F6D1; 0x1F6D2;
    0x1F6D3; 0x1F6D4; 0x1F6D5; 0x1F6D6; 0x1F6D7; 0x1F6D8; 0x1F6DC; 0x1F6DD;
    0x1F6DE; 0x1F6DF; 0x1F6E0; 0x1F6E1; 0x1F6E2; 0x1F6E3; 0x1F6E4; 0x1F6E5;
    0x1F6E6; 0x1F6E7; 0x1F6E8; 0x1F6E9; 0x1F6EA; 0x1F6EB; 0x1F6EC; 0x1F6F0;
    0x1F6F1; 0x1F6F2; 0x1F6F3; 0x1F6F4; 0x1F6F5; 0x1F6F6; 0x1F6F7; 0x1F6F8;
    0x1F6F9; 0x1F6FA; 0x1F6FB; 0x1F6FC; 0x1F700; 0x1F701; 0x1F702; 0x1F703;
    0x1F704; 0x1F705; 0x1F706; 0x1F707; 0x1F708; 0x1F709; 0x1F70A; 0x1F70B;
    0x1F70C; 0x1F70D; 0x1F70E; 0x1F70F; 0x1F710; 0x1F711; 0x1F712; 0x1F713;
    0x1F714; 0x1F715; 0x1F716; 0x1F717; 0x1F718; 0x1F719; 0x1F71A; 0x1F71B;
    0x1F71C; 0x1F71D; 0x1F71E; 0x1F71F; 0x1F720; 0x1F721; 0x1F722; 0x1F723;
    0x1F724; 0x1F725; 0x1F726; 0x1F727; 0x1F728; 0x1F729; 0x1F72A; 0x1F72B;
    0x1F72C; 0x1F72D; 0x1F72E; 0x1F72F; 0x1F730; 0x1F731; 0x1F732; 0x1F733;
    0x1F734; 0x1F735; 0x1F736; 0x1F737; 0x1F738; 0x1F739; 0x1F73A; 0x1F73B;
    0x1F73C; 0x1F73D; 0x1F73E; 0x1F73F; 0x1F740; 0x1F741; 0x1F742; 0x1F743;
    0x1F744; 0x1F745; 0x1F746; 0x1F747; 0x1F748; 0x1F749; 0x1F74A; 0x1F74B;
    0x1F74C; 0x1F74D; 0x1F74E; 0x1F74F; 0x1F750; 0x1F751; 0x1F752; 0x1F753;
    0x1F754; 0x1F755; 0x1F756; 0x1F757; 0x1F758; 0x1F759; 0x1F75A; 0x1F75B;
    0x1F75C; 0x1F75D; 0x1F75E; 0x1F75F; 0x1F760; 0x1F761; 0x1F762; 0x1F763;
    0x1F764; 0x1F765; 0x1F766; 0x1F767; 0x1F768; 0x1F769; 0x1F76A; 0x1F76B;
    0x1F76C; 0x1F76D; 0x1F76E; 0x1F76F; 0x1F770; 0x1F771; 0x1F772; 0x1F773;
    0x1F774; 0x1F775; 0x1F776; 0x1F777; 0x1F778; 0x1F779; 0x1F77A; 0x1F77B;
    0x1F77C; 0x1F77D; 0x1F77E; 0x1F77F; 0x1F780; 0x1F781; 0x1F782; 0x1F783;
    0x1F784; 0x1F785; 0x1F786; 0x1F787; 0x1F788; 0x1F789; 0x1F78A; 0x1F78B;
    0x1F78C; 0x1F78D; 0x1F78E; 0x1F78F; 0x1F790; 0x1F791; 0x1F792; 0x1F793;
    0x1F794; 0x1F795; 0x1F796; 0x1F797; 0x1F798; 0x1F799; 0x1F79A; 0x1F79B;
    0x1F79C; 0x1F79D; 0x1F79E; 0x1F79F; 0x1F7A0; 0x1F7A1; 0x1F7A2; 0x1F7A3;
    0x1F7A4; 0x1F7A5; 0x1F7A6; 0x1F7A7; 0x1F7A8; 0x1F7A9; 0x1F7AA; 0x1F7AB;
    0x1F7AC; 0x1F7AD; 0x1F7AE; 0x1F7AF; 0x1F7B0; 0x1F7B1; 0x1F7B2; 0x1F7B3;
    0x1F7B4; 0x1F7B5; 0x1F7B6; 0x1F7B7; 0x1F7B8; 0x1F7B9; 0x1F7BA; 0x1F7BB;
    0x1F7BC; 0x1F7BD; 0x1F7BE; 0x1F7BF; 0x1F7C0; 0x1F7C1; 0x1F7C2; 0x1F7C3;
    0x1F7C4; 0x1F7C5; 0x1F7C6; 0x1F7C7; 0x1F7C8; 0x1F7C9; 0x1F7CA; 0x1F7CB;
    0x1F7CC; 0x1F7CD; 0x1F7CE; 0x1F7CF; 0x1F7D0; 0x1F7D1; 0x1F7D2; 0x1F7D3;
    0x1F7D4; 0x1F7D5; 0x1F7D6; 0x1F7D7; 0x1F7D8; 0x1F7D9; 0x1F7E0; 0x1F7E1;
    0x1F7E2; 0x1F7E3; 0x1F7E4; 0x1F7E5; 0x1F7E6; 0x1F7E7; 0x1F7E8; 0x1F7E9;
    0x1F7EA; 0x1F7EB; 0x1F7F0; 0x1F800; 0x1F801; 0x1F802; 0x1F803; 0x1F804;
    0x1F805; 0x1F806; 0x1F807; 0x1F808; 0x1F809; 0x1F80A; 0x1F80B; 0x1F810;
    0x1F811; 0x1F812; 0x1F813; 0x1F814; 0x1F815; 0x1F816; 0x1F817; 0x1F818;
    0x1F819; 0x1F81A; 0x1F81B; 0x1F81C; 0x1F81D; 0x1F81E; 0x1F81F; 0x1F820;
    0x1F821; 0x1F822; 0x1F823; 0x1F824; 0x1F825; 0x1F826; 0x1F827; 0x1F828;
    0x1F829; 0x1F82A; 0x1F82B; 0x1F82C; 0x1F82D; 0x1F82E; 0x1F82F; 0x1F830;
    0x1F831; 0x1F832; 0x1F833; 0x1F834; 0x1F835; 0x1F836; 0x1F837; 0x1F838;
    0x1F839; 0x1F83A; 0x1F83B; 0x1F83C; 0x1F83D; 0x1F83E; 0x1F83F; 0x1F840;
    0x1F841; 0x1F842; 0x1F843; 0x1F844; 0x1F845; 0x1F846; 0x1F847; 0x1F850;
    0x1F851; 0x1F852; 0x1F853; 0x1F854; 0x1F855; 0x1F856; 0x1F857; 0x1F858;
    0x1F859; 0x1F860; 0x1F861; 0x1F862; 0x1F863; 0x1F864; 0x1F865; 0x1F866;
    0x1F867; 0x1F868; 0x1F869; 0x1F86A; 0x1F86B; 0x1F86C; 0x1F86D; 0x1F86E;
    0x1F86F; 0x1F870; 0x1F871; 0x1F872; 0x1F873; 0x1F874; 0x1F875; 0x1F876;
    0x1F877; 0x1F878; 0x1F879; 0x1F87A; 0x1F87B; 0x1F87C; 0x1F87D; 0x1F87E;
    0x1F87F; 0x1F880; 0x1F881; 0x1F882; 0x1F883; 0x1F884; 0x1F885; 0x1F886;
    0x1F887; 0x1F890; 0x1F891; 0x1F892; 0x1F893; 0x1F894; 0x1F895; 0x1F896;
    0x1F897; 0x1F898; 0x1F899; 0x1F89A; 0x1F89B; 0x1F89C; 0x1F89D; 0x1F89E;
    0x1F89F; 0x1F8A0; 0x1F8A1; 0x1F8A2; 0x1F8A3; 0x1F8A4; 0x1F8A5; 0x1F8A6;
    0x1F8A7; 0x1F8A8; 0x1F8A9; 0x1F8AA; 0x1F8AB; 0x1F8AC; 0x1F8AD; 0x1F8B0;
    0x1F8B1; 0x1F8B2; 0x1F8B3; 0x1F8B4; 0x1F8B5; 0x1F8B6; 0x1F8B7; 0x1F8B8;
    0x1F8B9; 0x1F8BA; 0x1F8BB; 0x1F8C0; 0x1F8C1; 0x1F8D0; 0x1F8D1; 0x1F8D2;
    0x1F8D3; 0x1F8D4; 0x1F8D5; 0x1F8D6; 0x1F8D7; 0x1F8D8; 0x1F900; 0x1F901;
    0x1F902; 0x1F903; 0x1F904; 0x1F905; 0x1F906; 0x1F907; 0x1F908; 0x1F909;
    0x1F90A; 0x1F90B; 0x1F90C; 0x1F90D; 0x1F90E; 0x1F90F; 0x1F910; 0x1F911;
    0x1F912; 0x1F913; 0x1F914; 0x1F915; 0x1F916; 0x1F917; 0x1F918; 0x1F919;
    0x1F91A; 0x1F91B; 0x1F91C; 0x1F91D; 0x1F91E; 0x1F91F; 0x1F920; 0x1F921;
    0x1F922; 0x1F923; 0x1F924; 0x1F925; 0x1F926; 0x1F927; 0x1F928; 0x1F929;
    0x1F92A; 0x1F92B; 0x1F92C; 0x1F92D; 0x1F92E; 0x1F92F; 0x1F930; 0x1F931;
    0x1F932; 0x1F933; 0x1F934; 0x1F935; 0x1F936; 0x1F937; 0x1F938; 0x1F939;
    0x1F93A; 0x1F93B; 0x1F93C; 0x1F93D; 0x1F93E; 0x1F93F; 0x1F940; 0x1F941;
    0x1F942; 0x1F943; 0x1F944; 0x1F945; 0x1F946; 0x1F947; 0x1F948; 0x1F949;
    0x1F94A; 0x1F94B; 0x1F94C; 0x1F94D; 0x1F94E; 0x1F94F; 0x1F950; 0x1F951;
    0x1F952; 0x1F953; 0x1F954; 0x1F955; 0x1F956; 0x1F957; 0x1F958; 0x1F959;
    0x1F95A; 0x1F95B; 0x1F95C; 0x1F95D; 0x1F95E; 0x1F95F; 0x1F960; 0x1F961;
    0x1F962; 0x1F963; 0x1F964; 0x1F965; 0x1F966; 0x1F967; 0x1F968; 0x1F969;
    0x1F96A; 0x1F96B; 0x1F96C; 0x1F96D; 0x1F96E; 0x1F96F; 0x1F970; 0x1F971;
    0x1F972; 0x1F973; 0x1F974; 0x1F975; 0x1F976; 0x1F977; 0x1F978; 0x1F979;
    0x1F97A; 0x1F97B; 0x1F97C; 0x1F97D; 0x1F97E; 0x1F97F; 0x1F980; 0x1F981;
    0x1F982; 0x1F983; 0x1F984; 0x1F985; 0x1F986; 0x1F987; 0x1F988; 0x1F989;
    0x1F98A; 0x1F98B; 0x1F98C; 0x1F98D; 0x1F98E; 0x1F98F; 0x1F990; 0x1F991;
    0x1F992; 0x1F993; 0x1F994; 0x1F995; 0x1F996; 0x1F997; 0x1F998; 0x1F999;
    0x1F99A; 0x1F99B; 0x1F99C; 0x1F99D; 0x1F99E; 0x1F99F; 0x1F9A0; 0x1F9A1;
    0x1F9A2; 0x1F9A3; 0x1F9A4; 0x1F9A5; 0x1F9A6; 0x1F9A7; 0x1F9A8; 0x1F9A9;
    0x1F9AA; 0x1F9AB; 0x1F9AC; 0x1F9AD; 0x1F9AE; 0x1F9AF; 0x1F9B0; 0x1F9B1;
    0x1F9B2; 0x1F9B3; 0x1F9B4; 0x1F9B5; 0x1F9B6; 0x1F9B7; 0x1F9B8; 0x1F9B9;
    0x1F9BA; 0x1F9BB; 0x1F9BC; 0x1F9BD; 0x1F9BE; 0x1F9BF; 0x1F9C0; 0x1F9C1;
    0x1F9C2; 0x1F9C3; 0x1F9C4; 0x1F9C5; 0x1F9C6; 0x1F9C7; 0x1F9C8; 0x1F9C9;
    0x1F9CA; 0x1F9CB; 0x1F9CC; 0x1F9CD; 0x1F9CE; 0x1F9CF; 0x1F9D0; 0x1F9D1;
    0x1F9D2; 0x1F9D3; 0x1F9D4; 0x1F9D5; 0x1F9D6; 0x1F9D7; 0x1F9D8; 0x1F9D9;
    0x1F9DA; 0x1F9DB; 0x1F9DC; 0x1F9DD; 0x1F9DE; 0x1F9DF; 0x1F9E0; 0x1F9E1;
    0x1F9E2; 0x1F9E3; 0x1F9E4; 0x1F9E5; 0x1F9E6; 0x1F9E7; 0x1F9E8; 0x1F9E9;
    0x1F9EA; 0x1F9EB; 0x1F9EC; 0x1F9ED; 0x1F9EE; 0x1F9EF; 0x1F9F0; 0x1F9F1;
    0x1F9F2; 0x1F9F3; 0x1F9F4; 0x1F9F5; 0x1F9F6; 0x1F9F7; 0x1F9F8; 0x1F9F9;
    0x1F9FA; 0x1F9FB; 0x1F9FC; 0x1F9FD; 0x1F9FE; 0x1F9FF; 0x1FA00; 0x1FA01;
    0x1FA02; 0x1FA03; 0x1FA04; 0x1FA05; 0x1FA06; 0x1FA07; 0x1FA08; 0x1FA09;
    0x1FA0A; 0x1FA0B; 0x1FA0C; 0x1FA0D; 0x1FA0E; 0x1FA0F; 0x1FA10; 0x1FA11;
    0x1FA12; 0x1FA13; 0x1FA14; 0x1FA15; 0x1FA16; 0x1FA17; 0x1FA18; 0x1FA19;
    0x1FA1A; 0x1FA1B; 0x1FA1C; 0x1FA1D; 0x1FA1E; 0x1FA1F; 0x1FA20; 0x1FA21;
    0x1FA22; 0x1FA23; 0x1FA24; 0x1FA25; 0x1FA26; 0x1FA27; 0x1FA28; 0x1FA29;
    0x1FA2A; 0x1FA2B; 0x1FA2C; 0x1FA2D; 0x1FA2E; 0x1FA2F; 0x1FA30; 0x1FA31;
    0x1FA32; 0x1FA33; 0x1FA34; 0x1FA35; 0x1FA36; 0x1FA37; 0x1FA38; 0x1FA39;
    0x1FA3A; 0x1FA3B; 0x1FA3C; 0x1FA3D; 0x1FA3E; 0x1FA3F; 0x1FA40; 0x1FA41;
    0x1FA42; 0x1FA43; 0x1FA44; 0x1FA45; 0x1FA46; 0x1FA47; 0x1FA48; 0x1FA49;
    0x1FA4A; 0x1FA4B; 0x1FA4C; 0x1FA4D; 0x1FA4E; 0x1FA4F; 0x1FA50; 0x1FA51;
    0x1FA52; 0x1FA53; 0x1FA54; 0x1FA55; 0x1FA56; 0x1FA57; 0x1FA60; 0x1FA61;
    0x1FA62; 0x1FA63; 0x1FA64; 0x1FA65; 0x1FA66; 0x1FA67; 0x1FA68; 0x1FA69;
    0x1FA6A; 0x1FA6B; 0x1FA6C; 0x1FA6D; 0x1FA70; 0x1FA71; 0x1FA72; 0x1FA73;
    0x1FA74; 0x1FA75; 0x1FA76; 0x1FA77; 0x1FA78; 0x1FA79; 0x1FA7A; 0x1FA7B;
    0x1FA7C; 0x1FA80; 0x1FA81; 0x1FA82; 0x1FA83; 0x1FA84; 0x1FA85; 0x1FA86;
    0x1FA87; 0x1FA88; 0x1FA89; 0x1FA8A; 0x1FA8E; 0x1FA8F; 0x1FA90; 0x1FA91;
    0x1FA92; 0x1FA93; 0x1FA94; 0x1FA95; 0x1FA96; 0x1FA97; 0x1FA98; 0x1FA99;
    0x1FA9A; 0x1FA9B; 0x1FA9C; 0x1FA9D; 0x1FA9E; 0x1FA9F; 0x1FAA0; 0x1FAA1;
    0x1FAA2; 0x1FAA3; 0x1FAA4; 0x1FAA5; 0x1FAA6; 0x1FAA7; 0x1FAA8; 0x1FAA9;
    0x1FAAA; 0x1FAAB; 0x1FAAC; 0x1FAAD; 0x1FAAE; 0x1FAAF; 0x1FAB0; 0x1FAB1;
    0x1FAB2; 0x1FAB3; 0x1FAB4; 0x1FAB5; 0x1FAB6; 0x1FAB7; 0x1FAB8; 0x1FAB9;
    0x1FABA; 0x1FABB; 0x1FABC; 0x1FABD; 0x1FABE; 0x1FABF; 0x1FAC0; 0x1FAC1;
    0x1FAC2; 0x1FAC3; 0x1FAC4; 0x1FAC5; 0x1FAC6; 0x1FAC8; 0x1FACD; 0x1FACE;
    0x1FACF; 0x1FAD0; 0x1FAD1; 0x1FAD2; 0x1FAD3; 0x1FAD4; 0x1FAD5; 0x1FAD6;
    0x1FAD7; 0x1FAD8; 0x1FAD9; 0x1FADA; 0x1FADB; 0x1FADC; 0x1FADF; 0x1FAE0;
    0x1FAE1; 0x1FAE2; 0x1FAE3; 0x1FAE4; 0x1FAE5; 0x1FAE6; 0x1FAE7; 0x1FAE8;
    0x1FAE9; 0x1FAEA; 0x1FAEF; 0x1FAF0; 0x1FAF1; 0x1FAF2; 0x1FAF3; 0x1FAF4;
    0x1FAF5; 0x1FAF6; 0x1FAF7; 0x1FAF8; 0x1FB00; 0x1FB01; 0x1FB02; 0x1FB03;
    0x1FB04; 0x1FB05; 0x1FB06; 0x1FB07; 0x1FB08; 0x1FB09; 0x1FB0A; 0x1FB0B;
    0x1FB0C; 0x1FB0D; 0x1FB0E; 0x1FB0F; 0x1FB10; 0x1FB11; 0x1FB12; 0x1FB13;
    0x1FB14; 0x1FB15; 0x1FB16; 0x1FB17; 0x1FB18; 0x1FB19; 0x1FB1A; 0x1FB1B;
    0x1FB1C; 0x1FB1D; 0x1FB1E; 0x1FB1F; 0x1FB20; 0x1FB21; 0x1FB22; 0x1FB23;
    0x1FB24; 0x1FB25; 0x1FB26; 0x1FB27; 0x1FB28; 0x1FB29; 0x1FB2A; 0x1FB2B;
    0x1FB2C; 0x1FB2D; 0x1FB2E; 0x1FB2F; 0x1FB30; 0x1FB31; 0x1FB32; 0x1FB33;
    0x1FB34; 0x1FB35; 0x1FB36; 0x1FB37; 0x1FB38; 0x1FB39; 0x1FB3A; 0x1FB3B;
    0x1FB3C; 0x1FB3D; 0x1FB3E; 0x1FB3F; 0x1FB40; 0x1FB41; 0x1FB42; 0x1FB43;
    0x1FB44; 0x1FB45; 0x1FB46; 0x1FB47; 0x1FB48; 0x1FB49; 0x1FB4A; 0x1FB4B;
    0x1FB4C; 0x1FB4D; 0x1FB4E; 0x1FB4F; 0x1FB50; 0x1FB51; 0x1FB52; 0x1FB53;
    0x1FB54; 0x1FB55; 0x1FB56; 0x1FB57; 0x1FB58; 0x1FB59; 0x1FB5A; 0x1FB5B;
    0x1FB5C; 0x1FB5D; 0x1FB5E; 0x1FB5F; 0x1FB60; 0x1FB61; 0x1FB62; 0x1FB63;
    0x1FB64; 0x1FB65; 0x1FB66; 0x1FB67; 0x1FB68; 0x1FB69; 0x1FB6A; 0x1FB6B;
    0x1FB6C; 0x1FB6D; 0x1FB6E; 0x1FB6F; 0x1FB70; 0x1FB71; 0x1FB72; 0x1FB73;
    0x1FB74; 0x1FB75; 0x1FB76; 0x1FB77; 0x1FB78; 0x1FB79; 0x1FB7A; 0x1FB7B;
    0x1FB7C; 0x1FB7D; 0x1FB7E; 0x1FB7F; 0x1FB80; 0x1FB81; 0x1FB82; 0x1FB83;
    0x1FB84; 0x1FB85; 0x1FB86; 0x1FB87; 0x1FB88; 0x1FB89; 0x1FB8A; 0x1FB8B;
    0x1FB8C; 0x1FB8D; 0x1FB8E; 0x1FB8F; 0x1FB90; 0x1FB91; 0x1FB92; 0x1FB94;
    0x1FB95; 0x1FB96; 0x1FB97; 0x1FB98; 0x1FB99; 0x1FB9A; 0x1FB9B; 0x1FB9C;
    0x1FB9D; 0x1FB9E; 0x1FB9F; 0x1FBA0; 0x1FBA1; 0x1FBA2; 0x1FBA3; 0x1FBA4;
    0x1FBA5; 0x1FBA6; 0x1FBA7; 0x1FBA8; 0x1FBA9; 0x1FBAA; 0x1FBAB; 0x1FBAC;
    0x1FBAD; 0x1FBAE; 0x1FBAF; 0x1FBB0; 0x1FBB1; 0x1FBB2; 0x1FBB3; 0x1FBB4;
    0x1FBB5; 0x1FBB6; 0x1FBB7; 0x1FBB8; 0x1FBB9; 0x1FBBA; 0x1FBBB; 0x1FBBC;
    0x1FBBD; 0x1FBBE; 0x1FBBF; 0x1FBC0; 0x1FBC1; 0x1FBC2; 0x1FBC3; 0x1FBC4;
    0x1FBC5; 0x1FBC6; 0x1FBC7; 0x1FBC8; 0x1FBC9; 0x1FBCA; 0x1FBCB; 0x1FBCC;
    0x1FBCD; 0x1FBCE; 0x1FBCF; 0x1FBD0; 0x1FBD1; 0x1FBD2; 0x1FBD3; 0x1FBD4;
    0x1FBD5; 0x1FBD6; 0x1FBD7; 0x1FBD8; 0x1FBD9; 0x1FBDA; 0x1FBDB; 0x1FBDC;
    0x1FBDD; 0x1FBDE; 0x1FBDF; 0x1FBE0; 0x1FBE1; 0x1FBE2; 0x1FBE3; 0x1FBE4;
    0x1FBE5; 0x1FBE6; 0x1FBE7; 0x1FBE8; 0x1FBE9; 0x1FBEA; 0x1FBEB; 0x1FBEC;
    0x1FBED; 0x1FBEE; 0x1FBEF; 0x1FBFA|]

let case_fold =
  [|0x0041, "\u{0061}"; 0x0042, "\u{0062}"; 0x0043, "\u{0063}";
    0x0044, "\u{0064}"; 0x0045, "\u{0065}"; 0x0046, "\u{0066}";
    0x0047, "\u{0067}"; 0x0048, "\u{0068}"; 0x0049, "\u{0069}";
    0x004A, "\u{006A}"; 0x004B, "\u{006B}"; 0x004C, "\u{006C}";
    0x004D, "\u{006D}"; 0x004E, "\u{006E}"; 0x004F, "\u{006F}";
    0x0050, "\u{0070}"; 0x0051, "\u{0071}"; 0x0052, "\u{0072}";
    0x0053, "\u{0073}"; 0x0054, "\u{0074}"; 0x0055, "\u{0075}";
    0x0056, "\u{0076}"; 0x0057, "\u{0077}"; 0x0058, "\u{0078}";
    0x0059, "\u{0079}"; 0x005A, "\u{007A}"; 0x00B5, "\u{03BC}";
    0x00C0, "\u{00E0}"; 0x00C1, "\u{00E1}"; 0x00C2, "\u{00E2}";
    0x00C3, "\u{00E3}"; 0x00C4, "\u{00E4}"; 0x00C5, "\u{00E5}";
    0x00C6, "\u{00E6}"; 0x00C7, "\u{00E7}"; 0x00C8, "\u{00E8}";
    0x00C9, "\u{00E9}"; 0x00CA, "\u{00EA}"; 0x00CB, "\u{00EB}";
    0x00CC, "\u{00EC}"; 0x00CD, "\u{00ED}"; 0x00CE, "\u{00EE}";
    0x00CF, "\u{00EF}"; 0x00D0, "\u{00F0}"; 0x00D1, "\u{00F1}";
    0x00D2, "\u{00F2}"; 0x00D3, "\u{00F3}"; 0x00D4, "\u{00F4}";
    0x00D5, "\u{00F5}"; 0x00D6, "\u{00F6}"; 0x00D8, "\u{00F8}";
    0x00D9, "\u{00F9}"; 0x00DA, "\u{00FA}"; 0x00DB, "\u{00FB}";
    0x00DC, "\u{00FC}"; 0x00DD, "\u{00FD}"; 0x00DE, "\u{00FE}";
    0x00DF, "\u{0073}\u{0073}"; 0x0100, "\u{0101}"; 0x0102, "\u{0103}";
    0x0104, "\u{0105}"; 0x0106, "\u{0107}"; 0x0108, "\u{0109}";
    0x010A, "\u{010B}"; 0x010C, "\u{010D}"; 0x010E, "\u{010F}";
    0x0110, "\u{0111}"; 0x0112, "\u{0113}"; 0x0114, "\u{0115}";
    0x0116, "\u{0117}"; 0x0118, "\u{0119}"; 0x011A, "\u{011B}";
    0x011C, "\u{011D}"; 0x011E, "\u{011F}"; 0x0120, "\u{0121}";
    0x0122, "\u{0123}"; 0x0124, "\u{0125}"; 0x0126, "\u{0127}";
    0x0128, "\u{0129}"; 0x012A, "\u{012B}"; 0x012C, "\u{012D}";
    0x012E, "\u{012F}"; 0x0130, "\u{0069}\u{0307}"; 0x0132, "\u{0133}";
    0x0134, "\u{0135}"; 0x0136, "\u{0137}"; 0x0139, "\u{013A}";
    0x013B, "\u{013C}"; 0x013D, "\u{013E}"; 0x013F, "\u{0140}";
    0x0141, "\u{0142}"; 0x0143, "\u{0144}"; 0x0145, "\u{0146}";
    0x0147, "\u{0148}"; 0x0149, "\u{02BC}\u{006E}"; 0x014A, "\u{014B}";
    0x014C, "\u{014D}"; 0x014E, "\u{014F}"; 0x0150, "\u{0151}";
    0x0152, "\u{0153}"; 0x0154, "\u{0155}"; 0x0156, "\u{0157}";
    0x0158, "\u{0159}"; 0x015A, "\u{015B}"; 0x015C, "\u{015D}";
    0x015E, "\u{015F}"; 0x0160, "\u{0161}"; 0x0162, "\u{0163}";
    0x0164, "\u{0165}"; 0x0166, "\u{0167}"; 0x0168, "\u{0169}";
    0x016A, "\u{016B}"; 0x016C, "\u{016D}"; 0x016E, "\u{016F}";
    0x0170, "\u{0171}"; 0x0172, "\u{0173}"; 0x0174, "\u{0175}";
    0x0176, "\u{0177}"; 0x0178, "\u{00FF}"; 0x0179, "\u{017A}";
    0x017B, "\u{017C}"; 0x017D, "\u{017E}"; 0x017F, "\u{0073}";
    0x0181, "\u{0253}"; 0x0182, "\u{0183}"; 0x0184, "\u{0185}";
    0x0186, "\u{0254}"; 0x0187, "\u{0188}"; 0x0189, "\u{0256}";
    0x018A, "\u{0257}"; 0x018B, "\u{018C}"; 0x018E, "\u{01DD}";
    0x018F, "\u{0259}"; 0x0190, "\u{025B}"; 0x0191, "\u{0192}";
    0x0193, "\u{0260}"; 0x0194, "\u{0263}"; 0x0196, "\u{0269}";
    0x0197, "\u{0268}"; 0x0198, "\u{0199}"; 0x019C, "\u{026F}";
    0x019D, "\u{0272}"; 0x019F, "\u{0275}"; 0x01A0, "\u{01A1}";
    0x01A2, "\u{01A3}"; 0x01A4, "\u{01A5}"; 0x01A6, "\u{0280}";
    0x01A7, "\u{01A8}"; 0x01A9, "\u{0283}"; 0x01AC, "\u{01AD}";
    0x01AE, "\u{0288}"; 0x01AF, "\u{01B0}"; 0x01B1, "\u{028A}";
    0x01B2, "\u{028B}"; 0x01B3, "\u{01B4}"; 0x01B5, "\u{01B6}";
    0x01B7, "\u{0292}"; 0x01B8, "\u{01B9}"; 0x01BC, "\u{01BD}";
    0x01C4, "\u{01C6}"; 0x01C5, "\u{01C6}"; 0x01C7, "\u{01C9}";
    0x01C8, "\u{01C9}"; 0x01CA, "\u{01CC}"; 0x01CB, "\u{01CC}";
    0x01CD, "\u{01CE}"; 0x01CF, "\u{01D0}"; 0x01D1, "\u{01D2}";
    0x01D3, "\u{01D4}"; 0x01D5, "\u{01D6}"; 0x01D7, "\u{01D8}";
    0x01D9, "\u{01DA}"; 0x01DB, "\u{01DC}"; 0x01DE, "\u{01DF}";
    0x01E0, "\u{01E1}"; 0x01E2, "\u{01E3}"; 0x01E4, "\u{01E5}";
    0x01E6, "\u{01E7}"; 0x01E8, "\u{01E9}"; 0x01EA, "\u{01EB}";
    0x01EC, "\u{01ED}"; 0x01EE, "\u{01EF}"; 0x01F0, "\u{006A}\u{030C}";
    0x01F1, "\u{01F3}"; 0x01F2, "\u{01F3}"; 0x01F4, "\u{01F5}";
    0x01F6, "\u{0195}"; 0x01F7, "\u{01BF}"; 0x01F8, "\u{01F9}";
    0x01FA, "\u{01FB}"; 0x01FC, "\u{01FD}"; 0x01FE, "\u{01FF}";
    0x0200, "\u{0201}"; 0x0202, "\u{0203}"; 0x0204, "\u{0205}";
    0x0206, "\u{0207}"; 0x0208, "\u{0209}"; 0x020A, "\u{020B}";
    0x020C, "\u{020D}"; 0x020E, "\u{020F}"; 0x0210, "\u{0211}";
    0x0212, "\u{0213}"; 0x0214, "\u{0215}"; 0x0216, "\u{0217}";
    0x0218, "\u{0219}"; 0x021A, "\u{021B}"; 0x021C, "\u{021D}";
    0x021E, "\u{021F}"; 0x0220, "\u{019E}"; 0x0222, "\u{0223}";
    0x0224, "\u{0225}"; 0x0226, "\u{0227}"; 0x0228, "\u{0229}";
    0x022A, "\u{022B}"; 0x022C, "\u{022D}"; 0x022E, "\u{022F}";
    0x0230, "\u{0231}"; 0x0232, "\u{0233}"; 0x023A, "\u{2C65}";
    0x023B, "\u{023C}"; 0x023D, "\u{019A}"; 0x023E, "\u{2C66}";
    0x0241, "\u{0242}"; 0x0243, "\u{0180}"; 0x0244, "\u{0289}";
    0x0245, "\u{028C}"; 0x0246, "\u{0247}"; 0x0248, "\u{0249}";
    0x024A, "\u{024B}"; 0x024C, "\u{024D}"; 0x024E, "\u{024F}";
    0x0345, "\u{03B9}"; 0x0370, "\u{0371}"; 0x0372, "\u{0373}";
    0x0376, "\u{0377}"; 0x037F, "\u{03F3}"; 0x0386, "\u{03AC}";
    0x0388, "\u{03AD}"; 0x0389, "\u{03AE}"; 0x038A, "\u{03AF}";
    0x038C, "\u{03CC}"; 0x038E, "\u{03CD}"; 0x038F, "\u{03CE}";
    0x0390, "\u{03B9}\u{0308}\u{0301}"; 0x0391, "\u{03B1}";
    0x0392, "\u{03B2}"; 0x0393, "\u{03B3}"; 0x0394, "\u{03B4}";
    0x0395, "\u{03B5}"; 0x0396, "\u{03B6}"; 0x0397, "\u{03B7}";
    0x0398, "\u{03B8}"; 0x0399, "\u{03B9}"; 0x039A, "\u{03BA}";
    0x039B, "\u{03BB}"; 0x039C, "\u{03BC}"; 0x039D, "\u{03BD}";
    0x039E, "\u{03BE}"; 0x039F, "\u{03BF}"; 0x03A0, "\u{03C0}";
    0x03A1, "\u{03C1}"; 0x03A3, "\u{03C3}"; 0x03A4, "\u{03C4}";
    0x03A5, "\u{03C5}"; 0x03A6, "\u{03C6}"; 0x03A7, "\u{03C7}";
    0x03A8, "\u{03C8}"; 0x03A9, "\u{03C9}"; 0x03AA, "\u{03CA}";
    0x03AB, "\u{03CB}"; 0x03B0, "\u{03C5}\u{0308}\u{0301}";
    0x03C2, "\u{03C3}"; 0x03CF, "\u{03D7}"; 0x03D0, "\u{03B2}";
    0x03D1, "\u{03B8}"; 0x03D5, "\u{03C6}"; 0x03D6, "\u{03C0}";
    0x03D8, "\u{03D9}"; 0x03DA, "\u{03DB}"; 0x03DC, "\u{03DD}";
    0x03DE, "\u{03DF}"; 0x03E0, "\u{03E1}"; 0x03E2, "\u{03E3}";
    0x03E4, "\u{03E5}"; 0x03E6, "\u{03E7}"; 0x03E8, "\u{03E9}";
    0x03EA, "\u{03EB}"; 0x03EC, "\u{03ED}"; 0x03EE, "\u{03EF}";
    0x03F0, "\u{03BA}"; 0x03F1, "\u{03C1}"; 0x03F4, "\u{03B8}";
    0x03F5, "\u{03B5}"; 0x03F7, "\u{03F8}"; 0x03F9, "\u{03F2}";
    0x03FA, "\u{03FB}"; 0x03FD, "\u{037B}"; 0x03FE, "\u{037C}";
    0x03FF, "\u{037D}"; 0x0400, "\u{0450}"; 0x0401, "\u{0451}";
    0x0402, "\u{0452}"; 0x0403, "\u{0453}"; 0x0404, "\u{0454}";
    0x0405, "\u{0455}"; 0x0406, "\u{0456}"; 0x0407, "\u{0457}";
    0x0408, "\u{0458}"; 0x0409, "\u{0459}"; 0x040A, "\u{045A}";
    0x040B, "\u{045B}"; 0x040C, "\u{045C}"; 0x040D, "\u{045D}";
    0x040E, "\u{045E}"; 0x040F, "\u{045F}"; 0x0410, "\u{0430}";
    0x0411, "\u{0431}"; 0x0412, "\u{0432}"; 0x0413, "\u{0433}";
    0x0414, "\u{0434}"; 0x0415, "\u{0435}"; 0x0416, "\u{0436}";
    0x0417, "\u{0437}"; 0x0418, "\u{0438}"; 0x0419, "\u{0439}";
    0x041A, "\u{043A}"; 0x041B, "\u{043B}"; 0x041C, "\u{043C}";
    0x041D, "\u{043D}"; 0x041E, "\u{043E}"; 0x041F, "\u{043F}";
    0x0420, "\u{0440}"; 0x0421, "\u{0441}"; 0x0422, "\u{0442}";
    0x0423, "\u{0443}"; 0x0424, "\u{0444}"; 0x0425, "\u{0445}";
    0x0426, "\u{0446}"; 0x0427, "\u{0447}"; 0x0428, "\u{0448}";
    0x0429, "\u{0449}"; 0x042A, "\u{044A}"; 0x042B, "\u{044B}";
    0x042C, "\u{044C}"; 0x042D, "\u{044D}"; 0x042E, "\u{044E}";
    0x042F, "\u{044F}"; 0x0460, "\u{0461}"; 0x0462, "\u{0463}";
    0x0464, "\u{0465}"; 0x0466, "\u{0467}"; 0x0468, "\u{0469}";
    0x046A, "\u{046B}"; 0x046C, "\u{046D}"; 0x046E, "\u{046F}";
    0x0470, "\u{0471}"; 0x0472, "\u{0473}"; 0x0474, "\u{0475}";
    0x0476, "\u{0477}"; 0x0478, "\u{0479}"; 0x047A, "\u{047B}";
    0x047C, "\u{047D}"; 0x047E, "\u{047F}"; 0x0480, "\u{0481}";
    0x048A, "\u{048B}"; 0x048C, "\u{048D}"; 0x048E, "\u{048F}";
    0x0490, "\u{0491}"; 0x0492, "\u{0493}"; 0x0494, "\u{0495}";
    0x0496, "\u{0497}"; 0x0498, "\u{0499}"; 0x049A, "\u{049B}";
    0x049C, "\u{049D}"; 0x049E, "\u{049F}"; 0x04A0, "\u{04A1}";
    0x04A2, "\u{04A3}"; 0x04A4, "\u{04A5}"; 0x04A6, "\u{04A7}";
    0x04A8, "\u{04A9}"; 0x04AA, "\u{04AB}"; 0x04AC, "\u{04AD}";
    0x04AE, "\u{04AF}"; 0x04B0, "\u{04B1}"; 0x04B2, "\u{04B3}";
    0x04B4, "\u{04B5}"; 0x04B6, "\u{04B7}"; 0x04B8, "\u{04B9}";
    0x04BA, "\u{04BB}"; 0x04BC, "\u{04BD}"; 0x04BE, "\u{04BF}";
    0x04C0, "\u{04CF}"; 0x04C1, "\u{04C2}"; 0x04C3, "\u{04C4}";
    0x04C5, "\u{04C6}"; 0x04C7, "\u{04C8}"; 0x04C9, "\u{04CA}";
    0x04CB, "\u{04CC}"; 0x04CD, "\u{04CE}"; 0x04D0, "\u{04D1}";
    0x04D2, "\u{04D3}"; 0x04D4, "\u{04D5}"; 0x04D6, "\u{04D7}";
    0x04D8, "\u{04D9}"; 0x04DA, "\u{04DB}"; 0x04DC, "\u{04DD}";
    0x04DE, "\u{04DF}"; 0x04E0, "\u{04E1}"; 0x04E2, "\u{04E3}";
    0x04E4, "\u{04E5}"; 0x04E6, "\u{04E7}"; 0x04E8, "\u{04E9}";
    0x04EA, "\u{04EB}"; 0x04EC, "\u{04ED}"; 0x04EE, "\u{04EF}";
    0x04F0, "\u{04F1}"; 0x04F2, "\u{04F3}"; 0x04F4, "\u{04F5}";
    0x04F6, "\u{04F7}"; 0x04F8, "\u{04F9}"; 0x04FA, "\u{04FB}";
    0x04FC, "\u{04FD}"; 0x04FE, "\u{04FF}"; 0x0500, "\u{0501}";
    0x0502, "\u{0503}"; 0x0504, "\u{0505}"; 0x0506, "\u{0507}";
    0x0508, "\u{0509}"; 0x050A, "\u{050B}"; 0x050C, "\u{050D}";
    0x050E, "\u{050F}"; 0x0510, "\u{0511}"; 0x0512, "\u{0513}";
    0x0514, "\u{0515}"; 0x0516, "\u{0517}"; 0x0518, "\u{0519}";
    0x051A, "\u{051B}"; 0x051C, "\u{051D}"; 0x051E, "\u{051F}";
    0x0520, "\u{0521}"; 0x0522, "\u{0523}"; 0x0524, "\u{0525}";
    0x0526, "\u{0527}"; 0x0528, "\u{0529}"; 0x052A, "\u{052B}";
    0x052C, "\u{052D}"; 0x052E, "\u{052F}"; 0x0531, "\u{0561}";
    0x0532, "\u{0562}"; 0x0533, "\u{0563}"; 0x0534, "\u{0564}";
    0x0535, "\u{0565}"; 0x0536, "\u{0566}"; 0x0537, "\u{0567}";
    0x0538, "\u{0568}"; 0x0539, "\u{0569}"; 0x053A, "\u{056A}";
    0x053B, "\u{056B}"; 0x053C, "\u{056C}"; 0x053D, "\u{056D}";
    0x053E, "\u{056E}"; 0x053F, "\u{056F}"; 0x0540, "\u{0570}";
    0x0541, "\u{0571}"; 0x0542, "\u{0572}"; 0x0543, "\u{0573}";
    0x0544, "\u{0574}"; 0x0545, "\u{0575}"; 0x0546, "\u{0576}";
    0x0547, "\u{0577}"; 0x0548, "\u{0578}"; 0x0549, "\u{0579}";
    0x054A, "\u{057A}"; 0x054B, "\u{057B}"; 0x054C, "\u{057C}";
    0x054D, "\u{057D}"; 0x054E, "\u{057E}"; 0x054F, "\u{057F}";
    0x0550, "\u{0580}"; 0x0551, "\u{0581}"; 0x0552, "\u{0582}";
    0x0553, "\u{0583}"; 0x0554, "\u{0584}"; 0x0555, "\u{0585}";
    0x0556, "\u{0586}"; 0x0587, "\u{0565}\u{0582}"; 0x10A0, "\u{2D00}";
    0x10A1, "\u{2D01}"; 0x10A2, "\u{2D02}"; 0x10A3, "\u{2D03}";
    0x10A4, "\u{2D04}"; 0x10A5, "\u{2D05}"; 0x10A6, "\u{2D06}";
    0x10A7, "\u{2D07}"; 0x10A8, "\u{2D08}"; 0x10A9, "\u{2D09}";
    0x10AA, "\u{2D0A}"; 0x10AB, "\u{2D0B}"; 0x10AC, "\u{2D0C}";
    0x10AD, "\u{2D0D}"; 0x10AE, "\u{2D0E}"; 0x10AF, "\u{2D0F}";
    0x10B0, "\u{2D10}"; 0x10B1, "\u{2D11}"; 0x10B2, "\u{2D12}";
    0x10B3, "\u{2D13}"; 0x10B4, "\u{2D14}"; 0x10B5, "\u{2D15}";
    0x10B6, "\u{2D16}"; 0x10B7, "\u{2D17}"; 0x10B8, "\u{2D18}";
    0x10B9, "\u{2D19}"; 0x10BA, "\u{2D1A}"; 0x10BB, "\u{2D1B}";
    0x10BC, "\u{2D1C}"; 0x10BD, "\u{2D1D}"; 0x10BE, "\u{2D1E}";
    0x10BF, "\u{2D1F}"; 0x10C0, "\u{2D20}"; 0x10C1, "\u{2D21}";
    0x10C2, "\u{2D22}"; 0x10C3, "\u{2D23}"; 0x10C4, "\u{2D24}";
    0x10C5, "\u{2D25}"; 0x10C7, "\u{2D27}"; 0x10CD, "\u{2D2D}";
    0x13F8, "\u{13F0}"; 0x13F9, "\u{13F1}"; 0x13FA, "\u{13F2}";
    0x13FB, "\u{13F3}"; 0x13FC, "\u{13F4}"; 0x13FD, "\u{13F5}";
    0x1C80, "\u{0432}"; 0x1C81, "\u{0434}"; 0x1C82, "\u{043E}";
    0x1C83, "\u{0441}"; 0x1C84, "\u{0442}"; 0x1C85, "\u{0442}";
    0x1C86, "\u{044A}"; 0x1C87, "\u{0463}"; 0x1C88, "\u{A64B}";
    0x1C89, "\u{1C8A}"; 0x1C90, "\u{10D0}"; 0x1C91, "\u{10D1}";
    0x1C92, "\u{10D2}"; 0x1C93, "\u{10D3}"; 0x1C94, "\u{10D4}";
    0x1C95, "\u{10D5}"; 0x1C96, "\u{10D6}"; 0x1C97, "\u{10D7}";
    0x1C98, "\u{10D8}"; 0x1C99, "\u{10D9}"; 0x1C9A, "\u{10DA}";
    0x1C9B, "\u{10DB}"; 0x1C9C, "\u{10DC}"; 0x1C9D, "\u{10DD}";
    0x1C9E, "\u{10DE}"; 0x1C9F, "\u{10DF}"; 0x1CA0, "\u{10E0}";
    0x1CA1, "\u{10E1}"; 0x1CA2, "\u{10E2}"; 0x1CA3, "\u{10E3}";
    0x1CA4, "\u{10E4}"; 0x1CA5, "\u{10E5}"; 0x1CA6, "\u{10E6}";
    0x1CA7, "\u{10E7}"; 0x1CA8, "\u{10E8}"; 0x1CA9, "\u{10E9}";
    0x1CAA, "\u{10EA}"; 0x1CAB, "\u{10EB}"; 0x1CAC, "\u{10EC}";
    0x1CAD, "\u{10ED}"; 0x1CAE, "\u{10EE}"; 0x1CAF, "\u{10EF}";
    0x1CB0, "\u{10F0}"; 0x1CB1, "\u{10F1}"; 0x1CB2, "\u{10F2}";
    0x1CB3, "\u{10F3}"; 0x1CB4, "\u{10F4}"; 0x1CB5, "\u{10F5}";
    0x1CB6, "\u{10F6}"; 0x1CB7, "\u{10F7}"; 0x1CB8, "\u{10F8}";
    0x1CB9, "\u{10F9}"; 0x1CBA, "\u{10FA}"; 0x1CBD, "\u{10FD}";
    0x1CBE, "\u{10FE}"; 0x1CBF, "\u{10FF}"; 0x1E00, "\u{1E01}";
    0x1E02, "\u{1E03}"; 0x1E04, "\u{1E05}"; 0x1E06, "\u{1E07}";
    0x1E08, "\u{1E09}"; 0x1E0A, "\u{1E0B}"; 0x1E0C, "\u{1E0D}";
    0x1E0E, "\u{1E0F}"; 0x1E10, "\u{1E11}"; 0x1E12, "\u{1E13}";
    0x1E14, "\u{1E15}"; 0x1E16, "\u{1E17}"; 0x1E18, "\u{1E19}";
    0x1E1A, "\u{1E1B}"; 0x1E1C, "\u{1E1D}"; 0x1E1E, "\u{1E1F}";
    0x1E20, "\u{1E21}"; 0x1E22, "\u{1E23}"; 0x1E24, "\u{1E25}";
    0x1E26, "\u{1E27}"; 0x1E28, "\u{1E29}"; 0x1E2A, "\u{1E2B}";
    0x1E2C, "\u{1E2D}"; 0x1E2E, "\u{1E2F}"; 0x1E30, "\u{1E31}";
    0x1E32, "\u{1E33}"; 0x1E34, "\u{1E35}"; 0x1E36, "\u{1E37}";
    0x1E38, "\u{1E39}"; 0x1E3A, "\u{1E3B}"; 0x1E3C, "\u{1E3D}";
    0x1E3E, "\u{1E3F}"; 0x1E40, "\u{1E41}"; 0x1E42, "\u{1E43}";
    0x1E44, "\u{1E45}"; 0x1E46, "\u{1E47}"; 0x1E48, "\u{1E49}";
    0x1E4A, "\u{1E4B}"; 0x1E4C, "\u{1E4D}"; 0x1E4E, "\u{1E4F}";
    0x1E50, "\u{1E51}"; 0x1E52, "\u{1E53}"; 0x1E54, "\u{1E55}";
    0x1E56, "\u{1E57}"; 0x1E58, "\u{1E59}"; 0x1E5A, "\u{1E5B}";
    0x1E5C, "\u{1E5D}"; 0x1E5E, "\u{1E5F}"; 0x1E60, "\u{1E61}";
    0x1E62, "\u{1E63}"; 0x1E64, "\u{1E65}"; 0x1E66, "\u{1E67}";
    0x1E68, "\u{1E69}"; 0x1E6A, "\u{1E6B}"; 0x1E6C, "\u{1E6D}";
    0x1E6E, "\u{1E6F}"; 0x1E70, "\u{1E71}"; 0x1E72, "\u{1E73}";
    0x1E74, "\u{1E75}"; 0x1E76, "\u{1E77}"; 0x1E78, "\u{1E79}";
    0x1E7A, "\u{1E7B}"; 0x1E7C, "\u{1E7D}"; 0x1E7E, "\u{1E7F}";
    0x1E80, "\u{1E81}"; 0x1E82, "\u{1E83}"; 0x1E84, "\u{1E85}";
    0x1E86, "\u{1E87}"; 0x1E88, "\u{1E89}"; 0x1E8A, "\u{1E8B}";
    0x1E8C, "\u{1E8D}"; 0x1E8E, "\u{1E8F}"; 0x1E90, "\u{1E91}";
    0x1E92, "\u{1E93}"; 0x1E94, "\u{1E95}"; 0x1E96, "\u{0068}\u{0331}";
    0x1E97, "\u{0074}\u{0308}"; 0x1E98, "\u{0077}\u{030A}";
    0x1E99, "\u{0079}\u{030A}"; 0x1E9A, "\u{0061}\u{02BE}";
    0x1E9B, "\u{1E61}"; 0x1E9E, "\u{0073}\u{0073}"; 0x1EA0, "\u{1EA1}";
    0x1EA2, "\u{1EA3}"; 0x1EA4, "\u{1EA5}"; 0x1EA6, "\u{1EA7}";
    0x1EA8, "\u{1EA9}"; 0x1EAA, "\u{1EAB}"; 0x1EAC, "\u{1EAD}";
    0x1EAE, "\u{1EAF}"; 0x1EB0, "\u{1EB1}"; 0x1EB2, "\u{1EB3}";
    0x1EB4, "\u{1EB5}"; 0x1EB6, "\u{1EB7}"; 0x1EB8, "\u{1EB9}";
    0x1EBA, "\u{1EBB}"; 0x1EBC, "\u{1EBD}"; 0x1EBE, "\u{1EBF}";
    0x1EC0, "\u{1EC1}"; 0x1EC2, "\u{1EC3}"; 0x1EC4, "\u{1EC5}";
    0x1EC6, "\u{1EC7}"; 0x1EC8, "\u{1EC9}"; 0x1ECA, "\u{1ECB}";
    0x1ECC, "\u{1ECD}"; 0x1ECE, "\u{1ECF}"; 0x1ED0, "\u{1ED1}";
    0x1ED2, "\u{1ED3}"; 0x1ED4, "\u{1ED5}"; 0x1ED6, "\u{1ED7}";
    0x1ED8, "\u{1ED9}"; 0x1EDA, "\u{1EDB}"; 0x1EDC, "\u{1EDD}";
    0x1EDE, "\u{1EDF}"; 0x1EE0, "\u{1EE1}"; 0x1EE2, "\u{1EE3}";
    0x1EE4, "\u{1EE5}"; 0x1EE6, "\u{1EE7}"; 0x1EE8, "\u{1EE9}";
    0x1EEA, "\u{1EEB}"; 0x1EEC, "\u{1EED}"; 0x1EEE, "\u{1EEF}";
    0x1EF0, "\u{1EF1}"; 0x1EF2, "\u{1EF3}"; 0x1EF4, "\u{1EF5}";
    0x1EF6, "\u{1EF7}"; 0x1EF8, "\u{1EF9}"; 0x1EFA, "\u{1EFB}";
    0x1EFC, "\u{1EFD}"; 0x1EFE, "\u{1EFF}"; 0x1F08, "\u{1F00}";
    0x1F09, "\u{1F01}"; 0x1F0A, "\u{1F02}"; 0x1F0B, "\u{1F03}";
    0x1F0C, "\u{1F04}"; 0x1F0D, "\u{1F05}"; 0x1F0E, "\u{1F06}";
    0x1F0F, "\u{1F07}"; 0x1F18, "\u{1F10}"; 0x1F19, "\u{1F11}";
    0x1F1A, "\u{1F12}"; 0x1F1B, "\u{1F13}"; 0x1F1C, "\u{1F14}";
    0x1F1D, "\u{1F15}"; 0x1F28, "\u{1F20}"; 0x1F29, "\u{1F21}";
    0x1F2A, "\u{1F22}"; 0x1F2B, "\u{1F23}"; 0x1F2C, "\u{1F24}";
    0x1F2D, "\u{1F25}"; 0x1F2E, "\u{1F26}"; 0x1F2F, "\u{1F27}";
    0x1F38, "\u{1F30}"; 0x1F39, "\u{1F31}"; 0x1F3A, "\u{1F32}";
    0x1F3B, "\u{1F33}"; 0x1F3C, "\u{1F34}"; 0x1F3D, "\u{1F35}";
    0x1F3E, "\u{1F36}"; 0x1F3F, "\u{1F37}"; 0x1F48, "\u{1F40}";
    0x1F49, "\u{1F41}"; 0x1F4A, "\u{1F42}"; 0x1F4B, "\u{1F43}";
    0x1F4C, "\u{1F44}"; 0x1F4D, "\u{1F45}"; 0x1F50, "\u{03C5}\u{0313}";
    0x1F52, "\u{03C5}\u{0313}\u{0300}"; 0x1F54, "\u{03C5}\u{0313}\u{0301}";
    0x1F56, "\u{03C5}\u{0313}\u{0342}"; 0x1F59, "\u{1F51}";
    0x1F5B, "\u{1F53}"; 0x1F5D, "\u{1F55}"; 0x1F5F, "\u{1F57}";
    0x1F68, "\u{1F60}"; 0x1F69, "\u{1F61}"; 0x1F6A, "\u{1F62}";
    0x1F6B, "\u{1F63}"; 0x1F6C, "\u{1F64}"; 0x1F6D, "\u{1F65}";
    0x1F6E, "\u{1F66}"; 0x1F6F, "\u{1F67}"; 0x1F80, "\u{1F00}\u{03B9}";
    0x1F81, "\u{1F01}\u{03B9}"; 0x1F82, "\u{1F02}\u{03B9}";
    0x1F83, "\u{1F03}\u{03B9}"; 0x1F84, "\u{1F04}\u{03B9}";
    0x1F85, "\u{1F05}\u{03B9}"; 0x1F86, "\u{1F06}\u{03B9}";
    0x1F87, "\u{1F07}\u{03B9}"; 0x1F88, "\u{1F00}\u{03B9}";
    0x1F89, "\u{1F01}\u{03B9}"; 0x1F8A, "\u{1F02}\u{03B9}";
    0x1F8B, "\u{1F03}\u{03B9}"; 0x1F8C, "\u{1F04}\u{03B9}";
    0x1F8D, "\u{1F05}\u{03B9}"; 0x1F8E, "\u{1F06}\u{03B9}";
    0x1F8F, "\u{1F07}\u{03B9}"; 0x1F90, "\u{1F20}\u{03B9}";
    0x1F91, "\u{1F21}\u{03B9}"; 0x1F92, "\u{1F22}\u{03B9}";
    0x1F93, "\u{1F23}\u{03B9}"; 0x1F94, "\u{1F24}\u{03B9}";
    0x1F95, "\u{1F25}\u{03B9}"; 0x1F96, "\u{1F26}\u{03B9}";
    0x1F97, "\u{1F27}\u{03B9}"; 0x1F98, "\u{1F20}\u{03B9}";
    0x1F99, "\u{1F21}\u{03B9}"; 0x1F9A, "\u{1F22}\u{03B9}";
    0x1F9B, "\u{1F23}\u{03B9}"; 0x1F9C, "\u{1F24}\u{03B9}";
    0x1F9D, "\u{1F25}\u{03B9}"; 0x1F9E, "\u{1F26}\u{03B9}";
    0x1F9F, "\u{1F27}\u{03B9}"; 0x1FA0, "\u{1F60}\u{03B9}";
    0x1FA1, "\u{1F61}\u{03B9}"; 0x1FA2, "\u{1F62}\u{03B9}";
    0x1FA3, "\u{1F63}\u{03B9}"; 0x1FA4, "\u{1F64}\u{03B9}";
    0x1FA5, "\u{1F65}\u{03B9}"; 0x1FA6, "\u{1F66}\u{03B9}";
    0x1FA7, "\u{1F67}\u{03B9}"; 0x1FA8, "\u{1F60}\u{03B9}";
    0x1FA9, "\u{1F61}\u{03B9}"; 0x1FAA, "\u{1F62}\u{03B9}";
    0x1FAB, "\u{1F63}\u{03B9}"; 0x1FAC, "\u{1F64}\u{03B9}";
    0x1FAD, "\u{1F65}\u{03B9}"; 0x1FAE, "\u{1F66}\u{03B9}";
    0x1FAF, "\u{1F67}\u{03B9}"; 0x1FB2, "\u{1F70}\u{03B9}";
    0x1FB3, "\u{03B1}\u{03B9}"; 0x1FB4, "\u{03AC}\u{03B9}";
    0x1FB6, "\u{03B1}\u{0342}"; 0x1FB7, "\u{03B1}\u{0342}\u{03B9}";
    0x1FB8, "\u{1FB0}"; 0x1FB9, "\u{1FB1}"; 0x1FBA, "\u{1F70}";
    0x1FBB, "\u{1F71}"; 0x1FBC, "\u{03B1}\u{03B9}"; 0x1FBE, "\u{03B9}";
    0x1FC2, "\u{1F74}\u{03B9}"; 0x1FC3, "\u{03B7}\u{03B9}";
    0x1FC4, "\u{03AE}\u{03B9}"; 0x1FC6, "\u{03B7}\u{0342}";
    0x1FC7, "\u{03B7}\u{0342}\u{03B9}"; 0x1FC8, "\u{1F72}";
    0x1FC9, "\u{1F73}"; 0x1FCA, "\u{1F74}"; 0x1FCB, "\u{1F75}";
    0x1FCC, "\u{03B7}\u{03B9}"; 0x1FD2, "\u{03B9}\u{0308}\u{0300}";
    0x1FD3, "\u{03B9}\u{0308}\u{0301}"; 0x1FD6, "\u{03B9}\u{0342}";
    0x1FD7, "\u{03B9}\u{0308}\u{0342}"; 0x1FD8, "\u{1FD0}";
    0x1FD9, "\u{1FD1}"; 0x1FDA, "\u{1F76}"; 0x1FDB, "\u{1F77}";
    0x1FE2, "\u{03C5}\u{0308}\u{0300}"; 0x1FE3, "\u{03C5}\u{0308}\u{0301}";
    0x1FE4, "\u{03C1}\u{0313}"; 0x1FE6, "\u{03C5}\u{0342}";
    0x1FE7, "\u{03C5}\u{0308}\u{0342}"; 0x1FE8, "\u{1FE0}";
    0x1FE9, "\u{1FE1}"; 0x1FEA, "\u{1F7A}"; 0x1FEB, "\u{1F7B}";
    0x1FEC, "\u{1FE5}"; 0x1FF2, "\u{1F7C}\u{03B9}";
    0x1FF3, "\u{03C9}\u{03B9}"; 0x1FF4, "\u{03CE}\u{03B9}";
    0x1FF6, "\u{03C9}\u{0342}"; 0x1FF7, "\u{03C9}\u{0342}\u{03B9}";
    0x1FF8, "\u{1F78}"; 0x1FF9, "\u{1F79}"; 0x1FFA, "\u{1F7C}";
    0x1FFB, "\u{1F7D}"; 0x1FFC, "\u{03C9}\u{03B9}"; 0x2126, "\u{03C9}";
    0x212A, "\u{006B}"; 0x212B, "\u{00E5}"; 0x2132, "\u{214E}";
    0x2160, "\u{2170}"; 0x2161, "\u{2171}"; 0x2162, "\u{2172}";
    0x2163, "\u{2173}"; 0x2164, "\u{2174}"; 0x2165, "\u{2175}";
    0x2166, "\u{2176}"; 0x2167, "\u{2177}"; 0x2168, "\u{2178}";
    0x2169, "\u{2179}"; 0x216A, "\u{217A}"; 0x216B, "\u{217B}";
    0x216C, "\u{217C}"; 0x216D, "\u{217D}"; 0x216E, "\u{217E}";
    0x216F, "\u{217F}"; 0x2183, "\u{2184}"; 0x24B6, "\u{24D0}";
    0x24B7, "\u{24D1}"; 0x24B8, "\u{24D2}"; 0x24B9, "\u{24D3}";
    0x24BA, "\u{24D4}"; 0x24BB, "\u{24D5}"; 0x24BC, "\u{24D6}";
    0x24BD, "\u{24D7}"; 0x24BE, "\u{24D8}"; 0x24BF, "\u{24D9}";
    0x24C0, "\u{24DA}"; 0x24C1, "\u{24DB}"; 0x24C2, "\u{24DC}";
    0x24C3, "\u{24DD}"; 0x24C4, "\u{24DE}"; 0x24C5, "\u{24DF}";
    0x24C6, "\u{24E0}"; 0x24C7, "\u{24E1}"; 0x24C8, "\u{24E2}";
    0x24C9, "\u{24E3}"; 0x24CA, "\u{24E4}"; 0x24CB, "\u{24E5}";
    0x24CC, "\u{24E6}"; 0x24CD, "\u{24E7}"; 0x24CE, "\u{24E8}";
    0x24CF, "\u{24E9}"; 0x2C00, "\u{2C30}"; 0x2C01, "\u{2C31}";
    0x2C02, "\u{2C32}"; 0x2C03, "\u{2C33}"; 0x2C04, "\u{2C34}";
    0x2C05, "\u{2C35}"; 0x2C06, "\u{2C36}"; 0x2C07, "\u{2C37}";
    0x2C08, "\u{2C38}"; 0x2C09, "\u{2C39}"; 0x2C0A, "\u{2C3A}";
    0x2C0B, "\u{2C3B}"; 0x2C0C, "\u{2C3C}"; 0x2C0D, "\u{2C3D}";
    0x2C0E, "\u{2C3E}"; 0x2C0F, "\u{2C3F}"; 0x2C10, "\u{2C40}";
    0x2C11, "\u{2C41}"; 0x2C12, "\u{2C42}"; 0x2C13, "\u{2C43}";
    0x2C14, "\u{2C44}"; 0x2C15, "\u{2C45}"; 0x2C16, "\u{2C46}";
    0x2C17, "\u{2C47}"; 0x2C18, "\u{2C48}"; 0x2C19, "\u{2C49}";
    0x2C1A, "\u{2C4A}"; 0x2C1B, "\u{2C4B}"; 0x2C1C, "\u{2C4C}";
    0x2C1D, "\u{2C4D}"; 0x2C1E, "\u{2C4E}"; 0x2C1F, "\u{2C4F}";
    0x2C20, "\u{2C50}"; 0x2C21, "\u{2C51}"; 0x2C22, "\u{2C52}";
    0x2C23, "\u{2C53}"; 0x2C24, "\u{2C54}"; 0x2C25, "\u{2C55}";
    0x2C26, "\u{2C56}"; 0x2C27, "\u{2C57}"; 0x2C28, "\u{2C58}";
    0x2C29, "\u{2C59}"; 0x2C2A, "\u{2C5A}"; 0x2C2B, "\u{2C5B}";
    0x2C2C, "\u{2C5C}"; 0x2C2D, "\u{2C5D}"; 0x2C2E, "\u{2C5E}";
    0x2C2F, "\u{2C5F}"; 0x2C60, "\u{2C61}"; 0x2C62, "\u{026B}";
    0x2C63, "\u{1D7D}"; 0x2C64, "\u{027D}"; 0x2C67, "\u{2C68}";
    0x2C69, "\u{2C6A}"; 0x2C6B, "\u{2C6C}"; 0x2C6D, "\u{0251}";
    0x2C6E, "\u{0271}"; 0x2C6F, "\u{0250}"; 0x2C70, "\u{0252}";
    0x2C72, "\u{2C73}"; 0x2C75, "\u{2C76}"; 0x2C7E, "\u{023F}";
    0x2C7F, "\u{0240}"; 0x2C80, "\u{2C81}"; 0x2C82, "\u{2C83}";
    0x2C84, "\u{2C85}"; 0x2C86, "\u{2C87}"; 0x2C88, "\u{2C89}";
    0x2C8A, "\u{2C8B}"; 0x2C8C, "\u{2C8D}"; 0x2C8E, "\u{2C8F}";
    0x2C90, "\u{2C91}"; 0x2C92, "\u{2C93}"; 0x2C94, "\u{2C95}";
    0x2C96, "\u{2C97}"; 0x2C98, "\u{2C99}"; 0x2C9A, "\u{2C9B}";
    0x2C9C, "\u{2C9D}"; 0x2C9E, "\u{2C9F}"; 0x2CA0, "\u{2CA1}";
    0x2CA2, "\u{2CA3}"; 0x2CA4, "\u{2CA5}"; 0x2CA6, "\u{2CA7}";
    0x2CA8, "\u{2CA9}"; 0x2CAA, "\u{2CAB}"; 0x2CAC, "\u{2CAD}";
    0x2CAE, "\u{2CAF}"; 0x2CB0, "\u{2CB1}"; 0x2CB2, "\u{2CB3}";
    0x2CB4, "\u{2CB5}"; 0x2CB6, "\u{2CB7}"; 0x2CB8, "\u{2CB9}";
    0x2CBA, "\u{2CBB}"; 0x2CBC, "\u{2CBD}"; 0x2CBE, "\u{2CBF}";
    0x2CC0, "\u{2CC1}"; 0x2CC2, "\u{2CC3}"; 0x2CC4, "\u{2CC5}";
    0x2CC6, "\u{2CC7}"; 0x2CC8, "\u{2CC9}"; 0x2CCA, "\u{2CCB}";
    0x2CCC, "\u{2CCD}"; 0x2CCE, "\u{2CCF}"; 0x2CD0, "\u{2CD1}";
    0x2CD2, "\u{2CD3}"; 0x2CD4, "\u{2CD5}"; 0x2CD6, "\u{2CD7}";
    0x2CD8, "\u{2CD9}"; 0x2CDA, "\u{2CDB}"; 0x2CDC, "\u{2CDD}";
    0x2CDE, "\u{2CDF}"; 0x2CE0, "\u{2CE1}"; 0x2CE2, "\u{2CE3}";
    0x2CEB, "\u{2CEC}"; 0x2CED, "\u{2CEE}"; 0x2CF2, "\u{2CF3}";
    0xA640, "\u{A641}"; 0xA642, "\u{A643}"; 0xA644, "\u{A645}";
    0xA646, "\u{A647}"; 0xA648, "\u{A649}"; 0xA64A, "\u{A64B}";
    0xA64C, "\u{A64D}"; 0xA64E, "\u{A64F}"; 0xA650, "\u{A651}";
    0xA652, "\u{A653}"; 0xA654, "\u{A655}"; 0xA656, "\u{A657}";
    0xA658, "\u{A659}"; 0xA65A, "\u{A65B}"; 0xA65C, "\u{A65D}";
    0xA65E, "\u{A65F}"; 0xA660, "\u{A661}"; 0xA662, "\u{A663}";
    0xA664, "\u{A665}"; 0xA666, "\u{A667}"; 0xA668, "\u{A669}";
    0xA66A, "\u{A66B}"; 0xA66C, "\u{A66D}"; 0xA680, "\u{A681}";
    0xA682, "\u{A683}"; 0xA684, "\u{A685}"; 0xA686, "\u{A687}";
    0xA688, "\u{A689}"; 0xA68A, "\u{A68B}"; 0xA68C, "\u{A68D}";
    0xA68E, "\u{A68F}"; 0xA690, "\u{A691}"; 0xA692, "\u{A693}";
    0xA694, "\u{A695}"; 0xA696, "\u{A697}"; 0xA698, "\u{A699}";
    0xA69A, "\u{A69B}"; 0xA722, "\u{A723}"; 0xA724, "\u{A725}";
    0xA726, "\u{A727}"; 0xA728, "\u{A729}"; 0xA72A, "\u{A72B}";
    0xA72C, "\u{A72D}"; 0xA72E, "\u{A72F}"; 0xA732, "\u{A733}";
    0xA734, "\u{A735}"; 0xA736, "\u{A737}"; 0xA738, "\u{A739}";
    0xA73A, "\u{A73B}"; 0xA73C, "\u{A73D}"; 0xA73E, "\u{A73F}";
    0xA740, "\u{A741}"; 0xA742, "\u{A743}"; 0xA744, "\u{A745}";
    0xA746, "\u{A747}"; 0xA748, "\u{A749}"; 0xA74A, "\u{A74B}";
    0xA74C, "\u{A74D}"; 0xA74E, "\u{A74F}"; 0xA750, "\u{A751}";
    0xA752, "\u{A753}"; 0xA754, "\u{A755}"; 0xA756, "\u{A757}";
    0xA758, "\u{A759}"; 0xA75A, "\u{A75B}"; 0xA75C, "\u{A75D}";
    0xA75E, "\u{A75F}"; 0xA760, "\u{A761}"; 0xA762, "\u{A763}";
    0xA764, "\u{A765}"; 0xA766, "\u{A767}"; 0xA768, "\u{A769}";
    0xA76A, "\u{A76B}"; 0xA76C, "\u{A76D}"; 0xA76E, "\u{A76F}";
    0xA779, "\u{A77A}"; 0xA77B, "\u{A77C}"; 0xA77D, "\u{1D79}";
    0xA77E, "\u{A77F}"; 0xA780, "\u{A781}"; 0xA782, "\u{A783}";
    0xA784, "\u{A785}"; 0xA786, "\u{A787}"; 0xA78B, "\u{A78C}";
    0xA78D, "\u{0265}"; 0xA790, "\u{A791}"; 0xA792, "\u{A793}";
    0xA796, "\u{A797}"; 0xA798, "\u{A799}"; 0xA79A, "\u{A79B}";
    0xA79C, "\u{A79D}"; 0xA79E, "\u{A79F}"; 0xA7A0, "\u{A7A1}";
    0xA7A2, "\u{A7A3}"; 0xA7A4, "\u{A7A5}"; 0xA7A6, "\u{A7A7}";
    0xA7A8, "\u{A7A9}"; 0xA7AA, "\u{0266}"; 0xA7AB, "\u{025C}";
    0xA7AC, "\u{0261}"; 0xA7AD, "\u{026C}"; 0xA7AE, "\u{026A}";
    0xA7B0, "\u{029E}"; 0xA7B1, "\u{0287}"; 0xA7B2, "\u{029D}";
    0xA7B3, "\u{AB53}"; 0xA7B4, "\u{A7B5}"; 0xA7B6, "\u{A7B7}";
    0xA7B8, "\u{A7B9}"; 0xA7BA, "\u{A7BB}"; 0xA7BC, "\u{A7BD}";
    0xA7BE, "\u{A7BF}"; 0xA7C0, "\u{A7C1}"; 0xA7C2, "\u{A7C3}";
    0xA7C4, "\u{A794}"; 0xA7C5, "\u{0282}"; 0xA7C6, "\u{1D8E}";
    0xA7C7, "\u{A7C8}"; 0xA7C9, "\u{A7CA}"; 0xA7CB, "\u{0264}";
    0xA7CC, "\u{A7CD}"; 0xA7CE, "\u{A7CF}"; 0xA7D0, "\u{A7D1}";
    0xA7D2, "\u{A7D3}"; 0xA7D4, "\u{A7D5}"; 0xA7D6, "\u{A7D7}";
    0xA7D8, "\u{A7D9}"; 0xA7DA, "\u{A7DB}"; 0xA7DC, "\u{019B}";
    0xA7F5, "\u{A7F6}"; 0xAB70, "\u{13A0}"; 0xAB71, "\u{13A1}";
    0xAB72, "\u{13A2}"; 0xAB73, "\u{13A3}"; 0xAB74, "\u{13A4}";
    0xAB75, "\u{13A5}"; 0xAB76, "\u{13A6}"; 0xAB77, "\u{13A7}";
    0xAB78, "\u{13A8}"; 0xAB79, "\u{13A9}"; 0xAB7A, "\u{13AA}";
    0xAB7B, "\u{13AB}"; 0xAB7C, "\u{13AC}"; 0xAB7D, "\u{13AD}";
    0xAB7E, "\u{13AE}"; 0xAB7F, "\u{13AF}"; 0xAB80, "\u{13B0}";
    0xAB81, "\u{13B1}"; 0xAB82, "\u{13B2}"; 0xAB83, "\u{13B3}";
    0xAB84, "\u{13B4}"; 0xAB85, "\u{13B5}"; 0xAB86, "\u{13B6}";
    0xAB87, "\u{13B7}"; 0xAB88, "\u{13B8}"; 0xAB89, "\u{13B9}";
    0xAB8A, "\u{13BA}"; 0xAB8B, "\u{13BB}"; 0xAB8C, "\u{13BC}";
    0xAB8D, "\u{13BD}"; 0xAB8E, "\u{13BE}"; 0xAB8F, "\u{13BF}";
    0xAB90, "\u{13C0}"; 0xAB91, "\u{13C1}"; 0xAB92, "\u{13C2}";
    0xAB93, "\u{13C3}"; 0xAB94, "\u{13C4}"; 0xAB95, "\u{13C5}";
    0xAB96, "\u{13C6}"; 0xAB97, "\u{13C7}"; 0xAB98, "\u{13C8}";
    0xAB99, "\u{13C9}"; 0xAB9A, "\u{13CA}"; 0xAB9B, "\u{13CB}";
    0xAB9C, "\u{13CC}"; 0xAB9D, "\u{13CD}"; 0xAB9E, "\u{13CE}";
    0xAB9F, "\u{13CF}"; 0xABA0, "\u{13D0}"; 0xABA1, "\u{13D1}";
    0xABA2, "\u{13D2}"; 0xABA3, "\u{13D3}"; 0xABA4, "\u{13D4}";
    0xABA5, "\u{13D5}"; 0xABA6, "\u{13D6}"; 0xABA7, "\u{13D7}";
    0xABA8, "\u{13D8}"; 0xABA9, "\u{13D9}"; 0xABAA, "\u{13DA}";
    0xABAB, "\u{13DB}"; 0xABAC, "\u{13DC}"; 0xABAD, "\u{13DD}";
    0xABAE, "\u{13DE}"; 0xABAF, "\u{13DF}"; 0xABB0, "\u{13E0}";
    0xABB1, "\u{13E1}"; 0xABB2, "\u{13E2}"; 0xABB3, "\u{13E3}";
    0xABB4, "\u{13E4}"; 0xABB5, "\u{13E5}"; 0xABB6, "\u{13E6}";
    0xABB7, "\u{13E7}"; 0xABB8, "\u{13E8}"; 0xABB9, "\u{13E9}";
    0xABBA, "\u{13EA}"; 0xABBB, "\u{13EB}"; 0xABBC, "\u{13EC}";
    0xABBD, "\u{13ED}"; 0xABBE, "\u{13EE}"; 0xABBF, "\u{13EF}";
    0xFB00, "\u{0066}\u{0066}"; 0xFB01, "\u{0066}\u{0069}";
    0xFB02, "\u{0066}\u{006C}"; 0xFB03, "\u{0066}\u{0066}\u{0069}";
    0xFB04, "\u{0066}\u{0066}\u{006C}"; 0xFB05, "\u{0073}\u{0074}";
    0xFB06, "\u{0073}\u{0074}"; 0xFB13, "\u{0574}\u{0576}";
    0xFB14, "\u{0574}\u{0565}"; 0xFB15, "\u{0574}\u{056B}";
    0xFB16, "\u{057E}\u{0576}"; 0xFB17, "\u{0574}\u{056D}";
    0xFF21, "\u{FF41}"; 0xFF22, "\u{FF42}"; 0xFF23, "\u{FF43}";
    0xFF24, "\u{FF44}"; 0xFF25, "\u{FF45}"; 0xFF26, "\u{FF46}";
    0xFF27, "\u{FF47}"; 0xFF28, "\u{FF48}"; 0xFF29, "\u{FF49}";
    0xFF2A, "\u{FF4A}"; 0xFF2B, "\u{FF4B}"; 0xFF2C, "\u{FF4C}";
    0xFF2D, "\u{FF4D}"; 0xFF2E, "\u{FF4E}"; 0xFF2F, "\u{FF4F}";
    0xFF30, "\u{FF50}"; 0xFF31, "\u{FF51}"; 0xFF32, "\u{FF52}";
    0xFF33, "\u{FF53}"; 0xFF34, "\u{FF54}"; 0xFF35, "\u{FF55}";
    0xFF36, "\u{FF56}"; 0xFF37, "\u{FF57}"; 0xFF38, "\u{FF58}";
    0xFF39, "\u{FF59}"; 0xFF3A, "\u{FF5A}"; 0x10400, "\u{10428}";
    0x10401, "\u{10429}"; 0x10402, "\u{1042A}"; 0x10403, "\u{1042B}";
    0x10404, "\u{1042C}"; 0x10405, "\u{1042D}"; 0x10406, "\u{1042E}";
    0x10407, "\u{1042F}"; 0x10408, "\u{10430}"; 0x10409, "\u{10431}";
    0x1040A, "\u{10432}"; 0x1040B, "\u{10433}"; 0x1040C, "\u{10434}";
    0x1040D, "\u{10435}"; 0x1040E, "\u{10436}"; 0x1040F, "\u{10437}";
    0x10410, "\u{10438}"; 0x10411, "\u{10439}"; 0x10412, "\u{1043A}";
    0x10413, "\u{1043B}"; 0x10414, "\u{1043C}"; 0x10415, "\u{1043D}";
    0x10416, "\u{1043E}"; 0x10417, "\u{1043F}"; 0x10418, "\u{10440}";
    0x10419, "\u{10441}"; 0x1041A, "\u{10442}"; 0x1041B, "\u{10443}";
    0x1041C, "\u{10444}"; 0x1041D, "\u{10445}"; 0x1041E, "\u{10446}";
    0x1041F, "\u{10447}"; 0x10420, "\u{10448}"; 0x10421, "\u{10449}";
    0x10422, "\u{1044A}"; 0x10423, "\u{1044B}"; 0x10424, "\u{1044C}";
    0x10425, "\u{1044D}"; 0x10426, "\u{1044E}"; 0x10427, "\u{1044F}";
    0x104B0, "\u{104D8}"; 0x104B1, "\u{104D9}"; 0x104B2, "\u{104DA}";
    0x104B3, "\u{104DB}"; 0x104B4, "\u{104DC}"; 0x104B5, "\u{104DD}";
    0x104B6, "\u{104DE}"; 0x104B7, "\u{104DF}"; 0x104B8, "\u{104E0}";
    0x104B9, "\u{104E1}"; 0x104BA, "\u{104E2}"; 0x104BB, "\u{104E3}";
    0x104BC, "\u{104E4}"; 0x104BD, "\u{104E5}"; 0x104BE, "\u{104E6}";
    0x104BF, "\u{104E7}"; 0x104C0, "\u{104E8}"; 0x104C1, "\u{104E9}";
    0x104C2, "\u{104EA}"; 0x104C3, "\u{104EB}"; 0x104C4, "\u{104EC}";
    0x104C5, "\u{104ED}"; 0x104C6, "\u{104EE}"; 0x104C7, "\u{104EF}";
    0x104C8, "\u{104F0}"; 0x104C9, "\u{104F1}"; 0x104CA, "\u{104F2}";
    0x104CB, "\u{104F3}"; 0x104CC, "\u{104F4}"; 0x104CD, "\u{104F5}";
    0x104CE, "\u{104F6}"; 0x104CF, "\u{104F7}"; 0x104D0, "\u{104F8}";
    0x104D1, "\u{104F9}"; 0x104D2, "\u{104FA}"; 0x104D3, "\u{104FB}";
    0x10570, "\u{10597}"; 0x10571, "\u{10598}"; 0x10572, "\u{10599}";
    0x10573, "\u{1059A}"; 0x10574, "\u{1059B}"; 0x10575, "\u{1059C}";
    0x10576, "\u{1059D}"; 0x10577, "\u{1059E}"; 0x10578, "\u{1059F}";
    0x10579, "\u{105A0}"; 0x1057A, "\u{105A1}"; 0x1057C, "\u{105A3}";
    0x1057D, "\u{105A4}"; 0x1057E, "\u{105A5}"; 0x1057F, "\u{105A6}";
    0x10580, "\u{105A7}"; 0x10581, "\u{105A8}"; 0x10582, "\u{105A9}";
    0x10583, "\u{105AA}"; 0x10584, "\u{105AB}"; 0x10585, "\u{105AC}";
    0x10586, "\u{105AD}"; 0x10587, "\u{105AE}"; 0x10588, "\u{105AF}";
    0x10589, "\u{105B0}"; 0x1058A, "\u{105B1}"; 0x1058C, "\u{105B3}";
    0x1058D, "\u{105B4}"; 0x1058E, "\u{105B5}"; 0x1058F, "\u{105B6}";
    0x10590, "\u{105B7}"; 0x10591, "\u{105B8}"; 0x10592, "\u{105B9}";
    0x10594, "\u{105BB}"; 0x10595, "\u{105BC}"; 0x10C80, "\u{10CC0}";
    0x10C81, "\u{10CC1}"; 0x10C82, "\u{10CC2}"; 0x10C83, "\u{10CC3}";
    0x10C84, "\u{10CC4}"; 0x10C85, "\u{10CC5}"; 0x10C86, "\u{10CC6}";
    0x10C87, "\u{10CC7}"; 0x10C88, "\u{10CC8}"; 0x10C89, "\u{10CC9}";
    0x10C8A, "\u{10CCA}"; 0x10C8B, "\u{10CCB}"; 0x10C8C, "\u{10CCC}";
    0x10C8D, "\u{10CCD}"; 0x10C8E, "\u{10CCE}"; 0x10C8F, "\u{10CCF}";
    0x10C90, "\u{10CD0}"; 0x10C91, "\u{10CD1}"; 0x10C92, "\u{10CD2}";
    0x10C93, "\u{10CD3}"; 0x10C94, "\u{10CD4}"; 0x10C95, "\u{10CD5}";
    0x10C96, "\u{10CD6}"; 0x10C97, "\u{10CD7}"; 0x10C98, "\u{10CD8}";
    0x10C99, "\u{10CD9}"; 0x10C9A, "\u{10CDA}"; 0x10C9B, "\u{10CDB}";
    0x10C9C, "\u{10CDC}"; 0x10C9D, "\u{10CDD}"; 0x10C9E, "\u{10CDE}";
    0x10C9F, "\u{10CDF}"; 0x10CA0, "\u{10CE0}"; 0x10CA1, "\u{10CE1}";
    0x10CA2, "\u{10CE2}"; 0x10CA3, "\u{10CE3}"; 0x10CA4, "\u{10CE4}";
    0x10CA5, "\u{10CE5}"; 0x10CA6, "\u{10CE6}"; 0x10CA7, "\u{10CE7}";
    0x10CA8, "\u{10CE8}"; 0x10CA9, "\u{10CE9}"; 0x10CAA, "\u{10CEA}";
    0x10CAB, "\u{10CEB}"; 0x10CAC, "\u{10CEC}"; 0x10CAD, "\u{10CED}";
    0x10CAE, "\u{10CEE}"; 0x10CAF, "\u{10CEF}"; 0x10CB0, "\u{10CF0}";
    0x10CB1, "\u{10CF1}"; 0x10CB2, "\u{10CF2}"; 0x10D50, "\u{10D70}";
    0x10D51, "\u{10D71}"; 0x10D52, "\u{10D72}"; 0x10D53, "\u{10D73}";
    0x10D54, "\u{10D74}"; 0x10D55, "\u{10D75}"; 0x10D56, "\u{10D76}";
    0x10D57, "\u{10D77}"; 0x10D58, "\u{10D78}"; 0x10D59, "\u{10D79}";
    0x10D5A, "\u{10D7A}"; 0x10D5B, "\u{10D7B}"; 0x10D5C, "\u{10D7C}";
    0x10D5D, "\u{10D7D}"; 0x10D5E, "\u{10D7E}"; 0x10D5F, "\u{10D7F}";
    0x10D60, "\u{10D80}"; 0x10D61, "\u{10D81}"; 0x10D62, "\u{10D82}";
    0x10D63, "\u{10D83}"; 0x10D64, "\u{10D84}"; 0x10D65, "\u{10D85}";
    0x118A0, "\u{118C0}"; 0x118A1, "\u{118C1}"; 0x118A2, "\u{118C2}";
    0x118A3, "\u{118C3}"; 0x118A4, "\u{118C4}"; 0x118A5, "\u{118C5}";
    0x118A6, "\u{118C6}"; 0x118A7, "\u{118C7}"; 0x118A8, "\u{118C8}";
    0x118A9, "\u{118C9}"; 0x118AA, "\u{118CA}"; 0x118AB, "\u{118CB}";
    0x118AC, "\u{118CC}"; 0x118AD, "\u{118CD}"; 0x118AE, "\u{118CE}";
    0x118AF, "\u{118CF}"; 0x118B0, "\u{118D0}"; 0x118B1, "\u{118D1}";
    0x118B2, "\u{118D2}"; 0x118B3, "\u{118D3}"; 0x118B4, "\u{118D4}";
    0x118B5, "\u{118D5}"; 0x118B6, "\u{118D6}"; 0x118B7, "\u{118D7}";
    0x118B8, "\u{118D8}"; 0x118B9, "\u{118D9}"; 0x118BA, "\u{118DA}";
    0x118BB, "\u{118DB}"; 0x118BC, "\u{118DC}"; 0x118BD, "\u{118DD}";
    0x118BE, "\u{118DE}"; 0x118BF, "\u{118DF}"; 0x16E40, "\u{16E60}";
    0x16E41, "\u{16E61}"; 0x16E42, "\u{16E62}"; 0x16E43, "\u{16E63}";
    0x16E44, "\u{16E64}"; 0x16E45, "\u{16E65}"; 0x16E46, "\u{16E66}";
    0x16E47, "\u{16E67}"; 0x16E48, "\u{16E68}"; 0x16E49, "\u{16E69}";
    0x16E4A, "\u{16E6A}"; 0x16E4B, "\u{16E6B}"; 0x16E4C, "\u{16E6C}";
    0x16E4D, "\u{16E6D}"; 0x16E4E, "\u{16E6E}"; 0x16E4F, "\u{16E6F}";
    0x16E50, "\u{16E70}"; 0x16E51, "\u{16E71}"; 0x16E52, "\u{16E72}";
    0x16E53, "\u{16E73}"; 0x16E54, "\u{16E74}"; 0x16E55, "\u{16E75}";
    0x16E56, "\u{16E76}"; 0x16E57, "\u{16E77}"; 0x16E58, "\u{16E78}";
    0x16E59, "\u{16E79}"; 0x16E5A, "\u{16E7A}"; 0x16E5B, "\u{16E7B}";
    0x16E5C, "\u{16E7C}"; 0x16E5D, "\u{16E7D}"; 0x16E5E, "\u{16E7E}";
    0x16E5F, "\u{16E7F}"; 0x16EA0, "\u{16EBB}"; 0x16EA1, "\u{16EBC}";
    0x16EA2, "\u{16EBD}"; 0x16EA3, "\u{16EBE}"; 0x16EA4, "\u{16EBF}";
    0x16EA5, "\u{16EC0}"; 0x16EA6, "\u{16EC1}"; 0x16EA7, "\u{16EC2}";
    0x16EA8, "\u{16EC3}"; 0x16EA9, "\u{16EC4}"; 0x16EAA, "\u{16EC5}";
    0x16EAB, "\u{16EC6}"; 0x16EAC, "\u{16EC7}"; 0x16EAD, "\u{16EC8}";
    0x16EAE, "\u{16EC9}"; 0x16EAF, "\u{16ECA}"; 0x16EB0, "\u{16ECB}";
    0x16EB1, "\u{16ECC}"; 0x16EB2, "\u{16ECD}"; 0x16EB3, "\u{16ECE}";
    0x16EB4, "\u{16ECF}"; 0x16EB5, "\u{16ED0}"; 0x16EB6, "\u{16ED1}";
    0x16EB7, "\u{16ED2}"; 0x16EB8, "\u{16ED3}"; 0x1E900, "\u{1E922}";
    0x1E901, "\u{1E923}"; 0x1E902, "\u{1E924}"; 0x1E903, "\u{1E925}";
    0x1E904, "\u{1E926}"; 0x1E905, "\u{1E927}"; 0x1E906, "\u{1E928}";
    0x1E907, "\u{1E929}"; 0x1E908, "\u{1E92A}"; 0x1E909, "\u{1E92B}";
    0x1E90A, "\u{1E92C}"; 0x1E90B, "\u{1E92D}"; 0x1E90C, "\u{1E92E}";
    0x1E90D, "\u{1E92F}"; 0x1E90E, "\u{1E930}"; 0x1E90F, "\u{1E931}";
    0x1E910, "\u{1E932}"; 0x1E911, "\u{1E933}"; 0x1E912, "\u{1E934}";
    0x1E913, "\u{1E935}"; 0x1E914, "\u{1E936}"; 0x1E915, "\u{1E937}";
    0x1E916, "\u{1E938}"; 0x1E917, "\u{1E939}"; 0x1E918, "\u{1E93A}";
    0x1E919, "\u{1E93B}"; 0x1E91A, "\u{1E93C}"; 0x1E91B, "\u{1E93D}";
    0x1E91C, "\u{1E93E}"; 0x1E91D, "\u{1E93F}"; 0x1E91E, "\u{1E940}";
    0x1E91F, "\u{1E941}"; 0x1E920, "\u{1E942}"; 0x1E921, "\u{1E943}"|]
